<?php //28b978fc41c83bdce82e726c8ad1c4e0
/** @noinspection all */

namespace App\Model\Product {

    use App\Model\Product;
    use App\Model\Vendor;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Model\Attribute\_IH_AttributeValue_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductAttribute_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductAttribute_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductDocument_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductDocument_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductOffer_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductOffer_QB;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductPhoto_C;
    use LaravelIdea\Helper\App\Model\Product\_IH_ProductPhoto_QB;
    use LaravelIdea\Helper\App\Model\_IH_Product_QB;
    use LaravelIdea\Helper\App\Model\_IH_Vendor_QB;
    
    /**
     * @property int $id
     * @property int $attribute_id
     * @property int $product_id
     * @property int|null $attribute_value_id
     * @property string|null $value
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @method BelongsTo|_IH_AttributeValue_QB value()
     * @method static _IH_ProductAttribute_QB onWriteConnection()
     * @method _IH_ProductAttribute_QB newQuery()
     * @method static _IH_ProductAttribute_QB on(null|string $connection = null)
     * @method static _IH_ProductAttribute_QB query()
     * @method static _IH_ProductAttribute_QB with(array|string $relations)
     * @method _IH_ProductAttribute_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductAttribute_C|ProductAttribute[] all()
     * @ownLinks attribute_id,\App\Model\Attribute,id|attribute_value_id,\App\Model\Attribute\AttributeValue,id|product_id,\App\Model\Product,id
     * @mixin _IH_ProductAttribute_QB
     */
    class ProductAttribute extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property string $type
     * @property string $slug
     * @property string $filename
     * @property string|null $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ProductDocument_QB onWriteConnection()
     * @method _IH_ProductDocument_QB newQuery()
     * @method static _IH_ProductDocument_QB on(null|string $connection = null)
     * @method static _IH_ProductDocument_QB query()
     * @method static _IH_ProductDocument_QB with(array|string $relations)
     * @method _IH_ProductDocument_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductDocument_C|ProductDocument[] all()
     * @ownLinks product_id,\App\Model\Product,id
     * @mixin _IH_ProductDocument_QB
     */
    class ProductDocument extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property int $vendor_id
     * @property float|null $price
     * @property float|null $price_promo
     * @property int $stock
     * @property bool $should_validate_stock
     * @property int $priority
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property-read $validate_stock attribute
     * @property Product $product
     * @method BelongsTo|_IH_Product_QB product()
     * @property Vendor $vendor
     * @method BelongsTo|_IH_Vendor_QB vendor()
     * @method static _IH_ProductOffer_QB onWriteConnection()
     * @method _IH_ProductOffer_QB newQuery()
     * @method static _IH_ProductOffer_QB on(null|string $connection = null)
     * @method static _IH_ProductOffer_QB query()
     * @method static _IH_ProductOffer_QB with(array|string $relations)
     * @method _IH_ProductOffer_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductOffer_C|ProductOffer[] all()
     * @ownLinks product_id,\App\Model\Product,id
     * @mixin _IH_ProductOffer_QB
     */
    class ProductOffer extends Model {}
    
    /**
     * @property int $id
     * @property int $product_id
     * @property string $filename
     * @property int $priority
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Product $item
     * @method BelongsTo|_IH_Product_QB item()
     * @method static _IH_ProductPhoto_QB onWriteConnection()
     * @method _IH_ProductPhoto_QB newQuery()
     * @method static _IH_ProductPhoto_QB on(null|string $connection = null)
     * @method static _IH_ProductPhoto_QB query()
     * @method static _IH_ProductPhoto_QB with(array|string $relations)
     * @method _IH_ProductPhoto_QB newModelQuery()
     * @method int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ProductPhoto_C|ProductPhoto[] all()
     * @ownLinks product_id,\App\Model\Product,id
     * @mixin _IH_ProductPhoto_QB
     */
    class ProductPhoto extends Model {}
}