<a id="comments"></a>


<div class="fs-24 fw-800 mb-2">Comentarii (<?php echo e($reviews->count()); ?>) </div>


<?php if($reviews->count()): ?>


<?php if(auth()->guard()->guest()): ?>
<div class="mb-4 rounded-md border border-gray-300 border-2 d-flex align-items-center justify-content-between py-2 ps-4 pe-3">
    <div>
	Doar utilizatorii întregistrați pot comenta.
	<a href="<?php echo e(route('login')); ?>" class="text-orange fw-600 "> Log in </a>
	sau
	<a href="<?php echo e(route('register')); ?>" class="text-orange fw-600">cont nou</a>
    </div>

    <span class="bg-gray-300 text-gray-600 rounded-pill px-3 py-2 d-inline-block pointer-events-none">Trimite</span>
</div>
<?php endif; ?>


<?php else: ?>


<?php if(auth()->guard()->guest()): ?>

<div class="mb-4 rounded-md border border-gray-300 border-2 d-flex align-items-center justify-content-between py-2 ps-4 pe-3">
    <div>
	Doar utilizatorii întregistrați pot comenta.
	<a href="<?php echo e(route('login')); ?>" class="text-orange fw-600 "> Log in </a>
	sau
	<a href="<?php echo e(route('register')); ?>" class="text-orange fw-600">cont nou</a>
    </div>

    <span class="bg-gray-300 text-gray-600 rounded-pill px-3 py-2 d-inline-block pointer-events-none">Trimite</span>
</div>


<?php endif; ?>

    <div class="fs-15 fw-600 mb-3 mb-md-4">Nu există niciun  comentariu, fii primul care comentează.</div>
    <?php endif; ?>


    <div class="leave-comment <?php if(auth()->guard()->guest()): ?> d-none <?php endif; ?>" id="review-form">
	<?php if(auth()->guard()->check()): ?>

	<form enctype="multipart/form-data" action="<?php echo e(route('site.article.review.store', $article)); ?>" method="POST" class="form-review">
	    <?php echo csrf_field(); ?>

	    <input type="hidden" name="parent_id" value="0">


	    <div class="leave-comment-field d-flex align-items-center align-items-md-start">
		<div class="bg-white d-flex align-items-end border border-2 border-gray-300 ps-2 ps-md-4 py-2 pe-2 rounded-md flex-grow-1">
		    <div class="text-area flex-grow-1">
			<textarea class="form-control p-0 pe-3" rows="1"  name="body" required="" placeholder="Lasă un comentariu..."></textarea>
		    </div>

		    <div class="attach-photo flex-none">
			<input type="file" class="form-control cursor-pointer px-2 py-3" name="photo" placeholder="&nbsp;">
			<svg class="icon icon-md fill-gray-600 icon-camera"> <use xlink:href="#icon-camera"></use> </svg>
			<svg class="icon icon-md fill-black icon-check"> <use xlink:href="#icon-check"></use> </svg>
		    </div>
		</div>

		<button type="submit" class="send-btn btn btn-custom ms-2 ms-md-3 px-md-3 py-md-2">
		    <span class="fw-600 d-none d-md-inline-block">Trimite</span>

		    <svg class="icon icon-md fill-black d-md-none"> <use xlink:href="#icon-send"></use> </svg>
		</button>
	    </div>


	    
	    
	    

	    
	     
			
		    

		
	    

            
		
		    
			 
			
			
			
			

    

	<!--<?php echo $__env->make('site.parts.approve_gdpr', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>-->

	<!--<p class="small text-muted">  Numele va fi public la postare. </p>-->

	</form>

	<?php endif; ?>

	<?php if(auth()->guard()->guest()): ?>
	<div class="alert alert-warning">
	    Trebuie să fii autentificat pentru a publica un comentariu.
	</div>
	<?php endif; ?>
    </div>


    <div class="comment-list mt-4">
	<?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

	<a id="comment-<?php echo e($review->id); ?>"></a>

	<div class="comment d-flex">

	    <div class="user-initial me-2 me-md-3"><?php echo e($review->user->getName()[0]); ?></div>

	    <div class="bg-gray-200 rounded-lg p-3 p-md-4 pb-3 flex-grow-1">
		<div class="mb-3">
		    <div class="fw-700 d-flex align-items-center">
			<?php echo e($review->user ? $review->user->getName() : 'user sters'); ?>


			 <?php if($review->user && $review->user->isAdmin()): ?>
			<svg class="icon icon-xs ms-1"> <use xlink:href="#icon-verified"></use> </svg>
			<!--<span class="badge bg-primary px-2 py-1 rounded-2 text-black"> Superchef </span>-->
			<?php endif; ?>
		    </div>

		    <div class="fs-15"> <?php echo e($review->created_at->diffForHumans()); ?>  </div>

		</div>

		<div class="comment__content fw-600">
		    <?php echo StringOperation::safeText($review->body); ?>

		</div>


		<?php if($review->hasPhoto()): ?>
		    <div class="comment__picture mt-2">
			<a href="<?php echo e($review->getPhotoUrl()); ?>" class="glightbox" data-lightbox="comment-photo">
			    <img src="<?php echo e($review->getPhotoUrl()); ?>" alt=""  class="img-fluid">
			</a>
		    </div>
		<?php endif; ?>

		<div class="text-end">
		    <button type="button" class="btn show-comment-form p-0" data-parent-id="<?php echo e($review->id); ?>">
			<svg class="icon icon-sm"> <use xlink:href="#icon-message-circle"></use> </svg>
			<span class="fw-700">Răspunde</span>
		    </button>
		</div>

	    </div>

        </div>

            <?php $__currentLoopData = $review->children; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review_child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
		<div class="comment mt-md-n3 mt-lg-n4 ps-3 ms-3 ms-md-5 d-flex">

		    <div class="user-initial me-3"><?php echo e($review_child->user->getName()[0]); ?></div>

		    <div class="bg-gray-200 rounded-lg p-3 p-md-4 flex-grow-1">
			<div class="mb-3">
			    <div class="d-flex align-items-center">
				<span class="fw-700">
				    <?php echo e($review_child->user ? $review_child->user->getName() : 'user sters'); ?>

				</span>

				<?php if($review_child->user && $review_child->user->isAdmin()): ?>
				<svg class="icon icon-xs ms-1"> <use xlink:href="#icon-verified"></use> </svg>
				<!--<span class="badge bg-primary px-2 py-1 rounded-2 text-black">Superchef </span>-->
				<?php endif; ?>
			    </div>

			    <div class="fs-15"><?php echo e($review_child->created_at->diffForHumans()); ?></div>

			</div>

			<div class="comment__content fw-600"> <?php echo StringOperation::safeText($review_child->body); ?> </div>

			<?php if($review_child->hasPhoto()): ?>
			    <div class="comment__picture mt-2">
				<a href="<?php echo e($review_child->getPhotoUrl()); ?>" class="glightbox" data-lightbox="comment-photo">
				    <img src="<?php echo e($review_child->getPhotoUrl()); ?>" alt="" class="img-fluid">
				</a>
			    </div>
			<?php endif; ?>
		    </div>
		</div>
	    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>


	<script>
    $('.show-comment-form').click(function () {
        var $injected_form = $(this).siblings('form');
        if ($injected_form.length) {
            if (!$injected_form.find('textarea').val()) {
                $(this).siblings('form').remove();
            }
            return;
        }
        $('.comment-list form').hide();
        $form = $('#review-form').children().clone();
        $form.addClass('small my-3 border-left border-primary pl-3 ml-3 ml-md-5 leave-comment').find('input[name=parent_id]').val(this.dataset.parentId);
        $(this).after($form);
        fpro();
    })
</script><?php /**PATH /home/superch1/public_html/resources/views/site/article/comments.blade.php ENDPATH**/ ?>