<?php if(isset($category)): ?>
    <tr role="button-or-not" class="<?php echo e($category->parent_id ?: 'bg-light'); ?>">
        <td style="padding-left: <?php echo e($depth * 5 * 10); ?>px">
        

        <!--⋅-->


            <a href="<?php echo e(route('admin.categories.edit', $category)); ?>"
               class="<?php echo e($category->parent_id == 0 ? 'font-bold h4' : ''); ?>">
                <?php if($category->photo): ?>
                    <img src="<?php echo e($category->getPhotoUrl()); ?>" style="width: 48px; height:48px; object-fit: contain"/>
                <?php endif; ?>
                <?php echo e($category->name); ?>

            </a>

            <?php if(!$category->parent_id && $category->show_in_menu): ?>
                <span class="badge badge-primary">
            apare in meniu
        </span>
            <?php endif; ?>
        </td>

        <td>
        <span class="badge badge-<?php echo e($category->is_active ? 'success' : 'danger'); ?>">
            <?php echo e($category->is_active ? 'activ' : 'inactiv'); ?>

        </span>
        </td>

        <?php if(!request('show_ids')): ?>

            <td style="width: 100px">
                <input class="form-control priority" value="<?php echo e($category->priority); ?>"
                       name="priority[<?php echo e($category->id); ?>]"/>
            </td>

            <td class="text-right">
                <div class="modal" id="item-<?php echo e($category->id); ?>" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog text-left" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h4 class="modal-title">Stergere obiect</h4>
                            </div>
                            <div class="modal-body text-left">
                                <?php if($category->can_be_deleted): ?>

                                    <p>
                                        Sigur doriti sa stergeti acesta categorie?
                                    </p>
                                    <p>
                                        Atentie, articolele care au fost asociate pe aceasta cateogrie vor ramane
                                        nelistate!
                                        De asemenea, toate subcategoriile vor disparea.
                                    </p>
                                <?php else: ?>
                                    <p>
                                        Aceasta categorie nu poate fi stearsa, e rezervata pentru sistem.
                                    </p>
                                <?php endif; ?>
                            </div>
                            <?php if($category->can_be_deleted): ?>
                                <div class="modal-footer">
                                    <form action="<?php echo e(route('admin.categories.destroy', $category)); ?>" method="POST"
                                          style="display: inline-block">
                                        <?php echo e(method_field('DELETE')); ?>

                                        <?php echo e(csrf_field()); ?>

                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Anuleaza
                                        </button>
                                        <input type="submit" value="sterge" class="btn  btn-danger"/>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>


                
                <?php if($category->can_have_children && $depth <= 0): ?>
                    
                    <a href="<?php echo e(route('admin.categories.create', ['parent_id' => $category->id])); ?>"
                       class="btn btn-primary <?php echo e($depth === 0 ? 'btn-whatever' : 'btn-xs '); ?>">adauga</a>
                <?php endif; ?>
                <a href="<?php echo e(route('admin.categories.edit', $category)); ?>"
                   class="btn btn-edit-or-not btn-success  <?php echo e($depth === 0 ? 'btn-whatever' : 'btn-xs '); ?>">edit</a>
                <a href="#"
                   class="btn btn-danger  <?php echo e($depth === 0 ? 'btn-whatever' : 'btn-xs '); ?>  <?php echo e($category->can_be_deleted ? '' : 'disabled'); ?>" data-toggle="modal"
                   data-target="#item-<?php echo e($category->id); ?>">sterge</a>
            </td>
        <?php else: ?>
            <td>
                <?php if(!count($category->subcats)): ?>
                    <?php echo e($category->id); ?>

                <?php else: ?>
                    -
                <?php endif; ?>
            </td>


        <?php endif; ?>
    </tr>
<?php endif; ?>

<?php if(!empty($categories) && count($categories)): ?>
    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

        <?php $__env->startComponent('admin.category.items', ['categories' => $category->subcats, 'category' => $category, 'depth' => $category->depth ]); ?>

        <?php if (isset($__componentOriginal36604aed96e76d71b41fb67e8388b727e5d52f35)): ?>
<?php $component = $__componentOriginal36604aed96e76d71b41fb67e8388b727e5d52f35; ?>
<?php unset($__componentOriginal36604aed96e76d71b41fb67e8388b727e5d52f35); ?>
<?php endif; ?>
<?php echo $__env->renderComponent(); ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?><?php /**PATH /home/superch1/public_html/resources/views/admin/category/items.blade.php ENDPATH**/ ?>