<?php /** @var \App\Model\Article $article */ ?>

<?php $__env->startSection('title', $category->name ?? $tag->name ?? 'Rețete care te inspiră'); ?>
<?php $__env->startSection('description'); ?>
Rețete <?php echo e($category->name ?? $tag->name ?? 'culinare'); ?>  de la SuperChef

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section>
        <div class="container">
            <div class="row mb-2 mb-md-4">
                <div class="col-md-12">
                    <h1 class="fw-700 fw-md-800 fs-36 tracking-tight"><?php echo $__env->yieldContent('title'); ?></h1>
		    <p class="fw-600">
			Te inspirăm cu rețetele noastre și te provocăm să devii un Superchef 💪
		    </p>

		    <button class="btn w-100 border border-3 border-gray-300 rounded-pill rounded-0 d-sm-none mb-3 d-flex align-items-center justify-content-center py-2" onclick="$('.categories-holder').addClass('show-categories')">
			<span class="fw-700">Vezi categoriile</span>
			<svg class="icon icon-xs fill-black ms-2"> <use xlink:href="#icon-arrow-right"></use>
		    </button>


		    <div class="categories-holder">
			
			<div class="d-flex align-items-center justify-content-between p-3 border-bottom mb-4 d-sm-none">
			    <div class="fw-600 fs-18">Categorii</div>
			    
			    <button class="btn p-0" onclick="$('.categories-holder').removeClass('show-categories')">
				<svg class="icon icon-xs fill-black"> <use xlink:href="#icon-x"></use> </svg>
			    </button>
			</div>
			
			<div class="recipes-categories p-2 p-md-0">
			    
			    <a class="btn <?php echo e(!$category->name ? 'active': ''); ?>" href="<?php echo e(route('site.recipes.index')); ?>"> Toate rețetele </a>
			    
			    <?php $__currentLoopData = $all_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $current_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<a class="btn <?php echo e($category == $current_category ? 'active' : ''); ?>" href="<?php echo e($current_category->getUrl()); ?>"> <?php echo e($current_category->name); ?></a>
			    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</div>
			
		    </div>
		    
		    <button class="btn categories-holder-trigger ms-2" style="display:none">
			<span class="btn-text">Vezi mai mult</span>
			 <svg class="icon icon-xs fill-black ms-2 anim"> <use xlink:href="#icon-arrow-down"></use> </svg>
		    </button>
		    
                </div>
            </div>

            <?php if(request('q')): ?>
                <div class="py-3 text-muted">
                    Se caută după "<b><?php echo e(request('q')); ?></b>"
                </div>
            <?php endif; ?>


	    <div class="row row-cols-2 row-cols-sm-3 row-cols-lg-4 gx-2 gy-3 g-md-3 g-xl-4">

	    <?php $__empty_1 = true; $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>


	    <div class="col category-holder">


		<div class="recipe--grid">
		    <a href="<?php echo e($article->getRecipeUrl()); ?>" class="a-absolute"></a>
		    <div class="recipe__badge"><?php echo e($article->params->skill ?? '-'); ?></div>
		    <div class="recipe__img mb-2 mb-md-3 ratio ratio-4x5">
			<img src="<?php echo e($article->getThumbUrl()); ?>" alt="<?php echo e($article->title); ?>" class="img-fluid"
			     loading="lazy">
		    </div>

		    <a href="<?php echo e($article->getRecipeUrl()); ?>" class="recipe__name">
			<?php echo e($article->title); ?>

		    </a>
		</div>

	    </div>
                <?php if($loop->iteration % 8 === 0): ?>
<!--		<div class="col-md-12 w-100">
		    <div class="googleBanner rounded-lg text-center py-2">
			<?php echo $__env->make('site.ads.adsense.4444688418', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		    </div>
		</div>-->
                <?php endif; ?>
		<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="lead">
                    <?php echo app('translator')->get('No article found'); ?>.
                </p>
		<?php endif; ?>

	    </div>

            <?php if($articles->hasPages()): ?>
                <div class="row mb-4 mt-3">
                    <div class="col-md-12">
                        <div class="text-center">
                           <div class="align-items-center d-flex justify-content-center pagination-bar">
                                    <?php echo e($articles->links()); ?>

                                </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="row">
                <div class="col-md-12">
                    <div class="googleBanner rounded-lg text-center py-2">
                        <?php echo $__env->make('site.ads.adsense.4444688418', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--<?php echo $__env->make('site.parts.recipe_carousel', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.site', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/superch1/public_html/resources/views/site/recipe/index.blade.php ENDPATH**/ ?>