<?php /** @var \App\Model\Article $article */ ?>
<?php /** @var \App\Model\Article\ArticlePhoto $photo */ ?>

@extends('layouts.site')
@section('title', $article->title)
@section('url', url()->current())


@section('meta')
<meta property="og:locale" content="ro_RO"/>
<meta property="og:locale:alternate" content="ro_RO"/>
<meta property="og:site_name" content="{{config('app.name')}}"/>
<meta property="og:title" content="{{ $article->title}}"/>
<meta property="og:url" content="@yield('url')"/>
<meta property="og:type" content="Article"/>
@if ($article->photos->count())
<meta property="og:image" content="{{$article->photos->first()->getThumbUrl()}}"/>
@endif

<script type="application/ld+json">
    {
    "@context": "https://schema.org/",
    "@type": "Recipe",
    "name": "{{$article->title}}",
    "image": [
    "{{$article->getThumbUrl()}}"
    ],
    "author": {
    "@type": "Person",
    "name": "{{config('app.name')}}"
    },
    "datePublished": "{{$article->published_at ? $article->published_at->format('Y-m-d') : $article->created_at->format('Y-m-d')  }}",
    "description": "{{Str::words(StringOperation::extractText($article->body), 30)}}",
    "prepTime": "PT{{$article->params->time_preparing ?? 0}}M",
    "cookTime": "PT{{$article->params->time_cooking ?? 0}}M",
    "totalTime": "PT{{$article->params->time_ready ?? 0}}M",
    "keywords": "{{$article->tags->pluck('name')->implode(', ')}}",
    "recipeYield": "{{$article->params->servings ?? $article->params->yield ?? ''}}",
    "recipeCategory": "{{$article->params->course ?? ''}}",
    "recipeCuisine": "{{$article->params->cuisine ?? ''}}"
    }


</script>
@endsection


@section('scripts')
<script>
    $(document).ready(function () {
	var paragraphs = $(".recipe__body > p, .recipe__body img");
	var first = paragraphs.first();
	var totalParagraphs = paragraphs.length;

	// insert ad in first paragraph
	// need our pub-ID here (andrei)

	if (first.length) {
	    first.after('<div class="my-3" style="width: 100%"><ins class=adsbygoogle style=display:block data-ad-client=ca-pub-0000000000 data-ad-slot=0000000000  data-ad-format=auto data-full-width-responsive=true></ins></div>');
	    (adsbygoogle = window.adsbygoogle || []).push({});
	}

	if (totalParagraphs >= 10) {
	    // insert ad after paragraph no 25%
	    paragraphs.eq(Math.ceil(totalParagraphs * 20 / 100) - 1)
		    .after('<div class="my-3" style="width: 350px; height: 350px;"><ins class=adsbygoogle style="display:block; text-align:center;" data-ad-layout=in-article data-ad-format=fluid data-ad-client=ca-pub-0000000000  data-ad-slot=0000000000 ></ins></div>');
	    (adsbygoogle = window.adsbygoogle || []).push({});

	    // insert ad after paragraph no 50% and 75%
	    var selectedParagraphs = [
		paragraphs.eq(Math.ceil(totalParagraphs * 50 / 100) - 1),
		paragraphs.eq(Math.ceil(totalParagraphs * 75 / 100) - 1),
	    ];
	    selectedParagraphs.forEach(function (paragraph) {
		paragraph.after('<div class="my-3" style="width: 100%"><ins class=adsbygoogle style="display:block; text-align:center;" data-ad-layout=in-article data-ad-format=fluid data-ad-client=ca-pub-0000000000  data-ad-slot=0000000000 ></ins></div>');
		(adsbygoogle = window.adsbygoogle || []).push({});
	    });

	}
    });

</script>
@endsection

@section('content')

<section class="">
    <div class="container">

	<div class="row">
	    <div class="col-md-12">
		<div class="d-flex align-items-center mb-4 pb-3">
		    <a href="{{route('site.recipes.index')}}" class="me-3">
			<svg class="icon icon-md fill-black stroke-1 stroke-black circle-icon bg-gray-300"> <use xlink:href="#icon-arrow-right"></use> </svg>
		    </a>

		    <nav aria-label="breadcrumb">
			<ol class="breadcrumb mb-0">
			    <li class="breadcrumb-item"><a href="{{route('site.')}}">Acasă</a></li>
			    <li class="breadcrumb-item"><a href="{{route('site.recipes.index')}}">Inspirație Rețete</a></li>
			    <li class="breadcrumb-item active" aria-current="page">{{$article->title}}</li>
			</ol>
		    </nav>
		</div>
	    </div>
	</div>

	<div class="row recipe__details justify-content-center justify-content-lg-start">
	    <div class="col-md-11 col-lg-8 mt-lg-4 mt-xl-5 order-last order-lg-first">

		<div class="me-lg-5 pe-xl-4">
		    <h1 class="fs-40 fw-800"> {{$article->title}} </h1>

		    <div class="d-flex flex-wrap mb-3 mb-md-4 mb-lg-5">
			<div class="recipe__badge d-flex align-items-center">
			    <svg class="icon icon-md fill-black me-2"> <use xlink:href="#icon-award"></use> </svg>
			    {{$article->params->skill ?? '-'}}
			</div>
			<div class="recipe__badge d-flex align-items-center">
			    <svg class="icon icon-md fill-black me-2"> <use xlink:href="#icon-clock"></use> </svg>
			    {{$article->params->time_preparing ?? 0}} minute
			</div>
		    </div>

		    <div class="recipe-menu__items">
			<div class="mb-4 md-mb-5 menu-item" category="menu-details">
			    {!! $article->body !!}
			</div>

			<div class="mb-4 md-mb-5 menu-item" category="menu-ingredients">
			    <div class="fs-24 fw-800 mb-3">Lista cu ingrediente</div>

			    @foreach ($article->ingredients as $ingredient_group)

			    <div class="fw-600 fs-18 text-orange mb-1">
				{{$ingredient_group->name}}
			    </div>

			    <div class="ingredient-list mb-4 mb-lg-5">
				@isset($ingredient_group->items)
				<ul class="list-unstyled mb-0 border-top">
				    @foreach (collect($ingredient_group->items)->map(fn($item) => explode("\n", $item))->flatten() as $item)
				    @continue(!$item)
				    <li class="border-bottom border-gray-300 py-3">
					<div class="form-check d-flex align-items-center justify-content-between ps-0">

					    <input class="form-check-input order-last cursor-pointer" type="checkbox" value="" id="{{str_replace(' ','-',$item)}}">

					    <label class="form-check-label order-first cursor-pointer" for="{{str_replace(' ', '-', $item)}}">
						{{$item}}
					    </label>


					</div>
				    </li>
				    @endforeach
				</ul>
				@endisset

			    </div>
			    @endforeach
			</div>

			<div class="mb-4 md-mb-5 menu-item" category="menu-prep">
			    <div class="fs-24 fw-800 mb-3">Mod de preparare</div>

			    @if (!empty($article->steps))
			    @foreach ($article->steps as $step_group)
			    <div class="preparation-steps mb-4">

				@foreach ($step_group->steps as $step)
				<div class="step border border-2 border-gray-300 mb-3">

				    <div class="step__nr fw-800 mb-3 text-gray-600">{{$loop->iteration}} / {{$loop->count}}</div>

				    <div class="step__description fs-18">
					{!! nl2br($step->text) !!}
				    </div>
				</div>
				@endforeach

			    </div>
			    @endforeach
			    @endif

			    <div class="text-center">
				<a href="#" class="btn rounded-pill border border-2 show-all-steps px-4 py-2">
				    <span class="text-black fw-700"> Vezi toți pașii</span>

				    <svg class="icon icon-xxs  stroke-1 stroke-black fill-black ms-1"> <use xlink:href="#icon-chevron-down"></use> </svg>
				</a>
			    </div>

			</div>

			<div class="mb-4 md-mb-5 menu-item" category="menu-comments">
			    @include('site.article.comments', ['reviews' => $reviews])
			</div>
		    </div>
		</div>
	    </div>

	    <div class="col-md-11 col-lg-4 order-first order-lg-last">

		<div class="recipe__cover recipe__cover--two-columns mb-4 mb-md-5 sticky-top">
		    <img src="{{$article->photos->first()->getThumbUrl()}}" alt="" class="img-fluid">
		</div>

	    </div>
	</div>
    </div>
</section>
@if ($articles->count())
<section class="pt-0">
    <div class="container">

	<div class="row">
	    <div class="col-md-12">

		<div class="mb-4 pb-4 border-bottom">
		    @if ($article->tags->count())
		    <div class="fs-24 fw-800 mb-3">Taguri rețetă</div>

		    <div class="recipe--tags ms-n2">
			@foreach ($article->tags as $tag)
			<a class="btn" href="{{$tag->getUrl()}}"> {{$tag->name}}</a>
			@endforeach
		    </div>
                    @endif
		</div>

		<div class="fs-24 fw-800 mb-3 ">Rețete asemănătoare</div>

		<div class="row row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-4 g-3 g-xl-4 mb-4 mb-xl-5">
		    @foreach ($articles as $article)
		    <div class="col category-holder">

			<div class="recipe--grid">
			    <a href="{{$article->getRecipeUrl()}}" class="a-absolute"></a>
			    <div class="recipe__badge">{{$article->params->skill ?? '-'}}</div>
			    <div class="recipe__img mb-2 mb-md-3">
				<img src="{{$article->getThumbUrl()}}" alt="{{$article->title}}" class="img-fluid" loading="lazy">
			    </div>

			    <div class="recipe__category">
				{{$recipe->category->name ?? ''}}
			    </div>

			    <a href="{{$article->getRecipeUrl()}}" class="recipe__name">
				{{$article->title}}
			    </a>
			</div>
		    </div>
		    @endforeach

		</div>


	    </div>
	</div>
    </div>
</section>

@endif



<!--@include('site.parts.recipe_carousel')-->
@endsection
