<?php /** @var \App\Model\Article $article */ ?>
@extends('layouts.site')
@section('title', $category->name ?? $tag->name ?? 'Rețete care te inspiră')
@section('description')
Rețete {{$category->name ?? $tag->name ?? 'culinare'}}  de la SuperChef

@endsection

@section('content')
    <section>
        <div class="container">
            <div class="row mb-2 mb-md-4">
                <div class="col-md-12">
                    <h1 class="fw-700 fw-md-800 fs-36 tracking-tight">@yield('title')</h1>
		    <p class="fw-600">
			Te inspirăm cu rețetele noastre și te provocăm să devii un Superchef 💪
		    </p>

		    <button class="btn w-100 border border-3 border-gray-300 rounded-pill rounded-0 d-sm-none mb-3 d-flex align-items-center justify-content-center py-2" onclick="$('.categories-holder').addClass('show-categories')">
			<span class="fw-700">Vezi categoriile</span>
			<svg class="icon icon-xs fill-black ms-2"> <use xlink:href="#icon-arrow-right"></use>
		    </button>


		    <div class="categories-holder">
			
			<div class="d-flex align-items-center justify-content-between p-3 border-bottom mb-4 d-sm-none">
			    <div class="fw-600 fs-18">Categorii</div>
			    
			    <button class="btn p-0" onclick="$('.categories-holder').removeClass('show-categories')">
				<svg class="icon icon-xs fill-black"> <use xlink:href="#icon-x"></use> </svg>
			    </button>
			</div>
			
			<div class="recipes-categories p-2 p-md-0">
			    
			    <a class="btn {{!$category->name ? 'active': ''}}" href="{{route('site.recipes.index')}}"> Toate rețetele </a>
			    
			    @foreach ($all_categories as $current_category)
				<a class="btn {{$category == $current_category ? 'active' : ''}}" href="{{$current_category->getUrl()}}"> {{$current_category->name}}</a>
			    @endforeach
			</div>
			
		    </div>
		    
		    <button class="btn categories-holder-trigger ms-2" style="display:none">
			<span class="btn-text">Vezi mai mult</span>
			 <svg class="icon icon-xs fill-black ms-2 anim"> <use xlink:href="#icon-arrow-down"></use> </svg>
		    </button>
		    
                </div>
            </div>

            @if (request('q'))
                <div class="py-3 text-muted">
                    Se caută după "<b>{{request('q')}}</b>"
                </div>
            @endif


	    <div class="row row-cols-2 row-cols-sm-3 row-cols-lg-4 gx-2 gy-3 g-md-3 g-xl-4">

	    @forelse ($articles as $article)


	    <div class="col category-holder">


		<div class="recipe--grid">
		    <a href="{{$article->getRecipeUrl()}}" class="a-absolute"></a>
		    <div class="recipe__badge">{{$article->params->skill ?? '-'}}</div>
		    <div class="recipe__img mb-2 mb-md-3 ratio ratio-4x5">
			<img src="{{$article->getThumbUrl()}}" alt="{{$article->title}}" class="img-fluid"
			     loading="lazy">
		    </div>

		    <a href="{{$article->getRecipeUrl()}}" class="recipe__name">
			{{$article->title}}
		    </a>
		</div>

	    </div>
                @if ($loop->iteration % 8 === 0)
<!--		<div class="col-md-12 w-100">
		    <div class="googleBanner rounded-lg text-center py-2">
			@include('site.ads.adsense.4444688418')
		    </div>
		</div>-->
                @endif
		@empty
                <p class="lead">
                    @lang('No article found').
                </p>
		@endforelse

	    </div>

            @if ($articles->hasPages())
                <div class="row mb-4 mt-3">
                    <div class="col-md-12">
                        <div class="text-center">
                           <div class="align-items-center d-flex justify-content-center pagination-bar">
                                    {{$articles->links()}}
                                </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <div class="googleBanner rounded-lg text-center py-2">
                        @include('site.ads.adsense.4444688418')
                    </div>
                </div>
            </div>
        </div>
    </section>
<!--@include('site.parts.recipe_carousel')-->
@endsection
