<!-- modal oferta personalizata -->
<div class="modal fade" id="product-ask" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg px-xxl-3 pt-4 pt-md-0">

        <div class="modal-content ">
            <div class="modal-header justify-content-center">
                <p class="modal-title">Ofertă Personalizată</p>
            </div>
            <div class="modal-body bg-light2">
                <div class="px-3 px-md-4 px-lg-5 py-4">


                    <form
                            class="form-contact"
                            action="{{route('site.product.personalized_offer')}}" method="POST">
                        @csrf

                        <div class="form-group">
                            <label class="form-la">Numele tău*</label>
                            <input type="text" class="form-control" name="name"
                                   @auth
                                       value="{{auth()->user()->getName()}}"
                                   @endauth
                                   required>
                        </div>

                        <div class="form-row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="">Email*</label>
                                    <input type="email" class="form-control" name="email"
                                           @auth
                                               value="{{auth()->user()->email}}"
                                           @endauth
                                           required>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label class="">Telefon*</label>
                                    <input type="text" class="form-control" name="phone"
                                           required
                                    >
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="">Mențiuni</label>
                            <textarea name="body" class="form-control" rows="3"></textarea>
                        </div>

                        <div class="form-group">
                            <label class="">Produse</label>
                            <ul class="list list-unstyled small mb-4">
                                @foreach ($products as $product)
                                    <li>
                                        {{$product->name}} <span class="text-muted">({{$product->code}})</span>
                                    </li>
                                    <input type="hidden" name="products[]" value="{{$product->id}}"/>
                                @endforeach
                            </ul>
                        </div>


                        @include('site.parts.approve_gdpr')

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary  text-uppercase">
                                Trimite solicitarea
                            </button>
                        </div>

                    </form>

                </div>
            </div>

        </div>
    </div>
</div>