@extends('layouts.site')

@section('title', 'Retete cu SuperChef, retete pas cu pas')
@section('description', 'rețete simple, rețete video, rețete cu poze de la un profesionist')


@section('content')



<section class="cover py-0">
    <img src="{{asset('assets/site/images/cover.webp')}}" srcset="{{asset('assets/site/images/cover.webp')}} 1000w, {{asset('assets/site/images/cover.webp')}} 1500w" class="img-fluid cover__img" alt="">
    <div class="container h-100">
	<div class="row h-100 align-items-center justify-content-center">
	    <div class="col-md-10 col-lg-8">
		<div class="text-center">
		    <h1 class="fs-64 fw-800 text-white mb-3"> Și tu poți fi Superchef la tine în bucătărie</h1>
		    <button class="btn btn-custom cover-btn">Acceptă provocarea</button>
		</div>
	    </div>
	</div>
    </div>
</section>



<section class="bg-primary-300" id="home-description">
    <div class="container">
	<div class="row justify-content-center">
	    <div class="col-md-12 col-lg-11 col-xl-10">
		<div class="text-md-center">
		    <p class="mb-0 fw-500 fs-24">
			Superchef este un site fun care te ajută să descoperi cât de distractiv
			poate fi gătitul și împărtășirea experienței cu ceilalți. Nu suntem
			doar un site de rețete; aici te poți inspira, reinterpreta și arăta tuturor ce ai
			reușit să faci, iar în final vei primi voturi pentru rezultatul tău.
			Dacă ți se pare interesant, vino și descoperă cum poți deveni Superchef. 💪
		    </p>
		</div>
	    </div>
	</div>
    </div>
</section>



<section>
    <div class="container">
	<div class="row mb-3 mb-md-4 mb-xxl-5 pb-lg-2 pb-xxl-0">
	    <div class="col-md-12">
		<div class="text-center">
		    <div class="fw-700 fw-md-800 fs-36 tracking-tight">Rețete care te inspiră</div>
		</div>
	    </div>
	</div>

	<div class="row row-cols-2 row-cols-sm-3 row-cols-lg-4 gx-2 gy-3 g-md-3 g-xl-4">
	    @foreach ($recipes->slice(0,16) as $recipe)
	    <div class="col category-holder">
		<div class="recipe--grid">
		    <a href="{{$recipe->getRecipeUrl()}}" class="a-absolute"></a>
		    <div class="recipe__badge">{{$recipe->params->skill ?? '-'}}</div>
		    <div class="recipe__img mb-2 mb-md-3 ratio ratio-4x5">
			<img src="{{$recipe->getThumbUrl()}}" alt="{{$recipe->title}}" class="img-fluid" loading="lazy">
		    </div>
		    <?php /*
		   			<div class="recipe__category">
						{{$recipe->category->name ?? ''}}
					    </div>  */ ?>
		    <a href="{{$recipe->getRecipeUrl()}}" class="recipe__name">
			{{$recipe->title}}
			</a>
		    </div>
	    </div>
	    @endforeach
	</div>

	<div class="row mt-4">
	    <div class="col-md-12">
		<div class="text-center mt-3">
		    <a href="{{route('site.recipes.index')}}" class="btn btn-custom">
			Vezi toate rețetele
		    </a>
		</div>
	    </div>
	</div>
    </div>
</section>


@if($articles->count())
<section class="bg-primary-300">
    <div class="container">
	<div class="row mb-3 mb-md-4 mb-xxl-5 pb-lg-2 pb-xxl-0">
	    <div class="col-md-12">
		    <div class="text-center">
			<div class="fw-800 fs-36 tracking-tight">Povești din bucătărie</div>
		    </div>
		</div>
	    </div>

	<div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 g-3 g-xl-4">
	    @foreach ($articles as $article)
	    @component('site.article.item', compact('article')) @endcomponent
	    @endforeach
	</div>

	<div class="row mt-4">
	    <div class="col-md-12">
		<div class="text-center mt-3">
		    <a href="{{route('site.articles.index')}}" class="btn btn-custom">
			Vezi toate poveștile
		    </a>
		</div>
	    </div>
	</div>


    </div>
    </section>
    @endif
    @endsection



