<?php /** @var \App\Model\Gallery $gallery */ ?>

@extends('layouts.site')
@section('title', $gallery->name)
@section('url', url()->current())


@section('meta')
    <meta property="og:locale" content="ro_RO"/>
    <meta property="og:locale:alternate" content="ro_RO"/>
    <meta property="og:site_name" content="{{config('app.name')}}"/>
    <meta property="og:title" content="{{ $gallery->name}}"/>
    <meta property="og:url" content="@yield('url')"/>
    <meta property="og:type" content="Article"/>
    <meta property="og:image" content="{{$gallery->getThumbUrl()}}"/>
@endsection


@section('content')

    <section class="bg-light-green subheader pb-0">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <h1 class="title text-white">
                        {{$gallery->name}}
                    </h1>
                </div>
                <div class="col-md-12 text-center">
                    <img src="{{asset('assets/site/images/subheader-products.png')}}" alt="" class="img-fluid">
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row">
{{--                <div class="col-md-12 text-center">--}}
{{--                    <div class="title">Denumire album</div>--}}
{{--                </div>--}}

                <div class="col-md-12 mt-4 mt-md-5">
                    <div class="album-description">
                        {!!$gallery->description!!}
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="album-gallery-wrapper pt-0">
        <div class="album-gallery-bg"></div>
        <div class="container">
            <div class="row no-gutters popup-gallery ">
                @foreach($gallery->photos as $photo)
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <div class="gallery-photo">
                            <a href="{{$photo->getPhotoUrl()}}" class="a-absolute"></a>
                            <div class="img">
                                <img src="{{$photo->getThumbUrl()}}" alt="{{$gallery->name}}" class="img-fluid">
                            </div>
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    </section>
@endsection
