<div class="col-md-12 col-lg-3">
    <div class="blog-search">
        <form action="{{route('site.articles.index')}}">
            <div class="input-group search mb-3 border">
                <input type="text" name="q" class="form-control border-0" placeholder="@lang('Search in blog')..."
                required>
                <div class="input-group-append">
                    <button class="border-0 bg-transparent" type="submit">
                        <i class="fas fa-search text-muted"></i>
                    </button>
                </div>
            </div>
        </form>

        <div>
            <h6 class="text-uppercase">@lang('Categories')</h6>

            <ul class="list-unstyled blog-categories">
                @foreach ($categories as $current_category)
                    <li>
                        <a href="{{$current_category->getUrl()}}"
                           class="{{$category == $current_category ? 'font-weight-bold' : ''}}">
                            {{$current_category->name}}
                        </a>
                    </li>
                @endforeach
                <li>
                    <a href="{{route('site.articles.index')}}">
                        @lang('All')
                    </a>
                </li>
            </ul>
        </div>

        @if ($recent_articles->count())
            <div>
                <h6 class="text-uppercase mb-3">@lang('Recent articles')</h6>
                @foreach ($recent_articles as $current_article)
                    <div class="recent-article mb-3">
                        <div class="row align-items-center no-gutters">
                            <div class="col-4">
                                <a href="{{$current_article->getUrl()}}" class="a-absolute"></a>
                                <img src="{{$current_article->getThumbUrl()}}" alt=""
                                     class="img-fluid">
                            </div>
                            <div class="col-8 small pl-3">
                                <div class="name">
                                    <a href="{{$current_article->getUrl()}}">
                                        {{$current_article->title}}
                                    </a>
                                </div>
                                <div class="pt-2">{{$current_article->published_at->formatLocalized('%d %B, %Y')}}</div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>