<?php /** @var \App\Model\Article $article */ ?>
<?php /** @var \App\Model\Article\ArticlePhoto $photo */ ?>

@extends('layouts.site')
@section('title', $article->title)
@section('url', url()->current())


@section('meta')
    <meta property="og:locale" content="ro_RO"/>
    <meta property="og:locale:alternate" content="ro_RO"/>
    <meta property="og:site_name" content="{{config('app.name')}}"/>
    <meta property="og:title" content="{{ $article->title}}"/>
    <meta property="og:url" content="@yield('url')"/>
    <meta property="og:type" content="Article"/>
    <meta property="og:image" content="{{$article->getThumbUrl()}}"/>
@endsection

@section('content')

<section class="post__details pt-4">
    <div class="container">
	<div class="row justify-content-center">
	    <div class="col-md-10 col-lg-8 mb-4">

		<div class="d-flex align-items-center mb-4 pb-4">
		    <a href="{{route('site.articles.index')}}" class="me-3">
			<svg class="icon icon-md fill-black stroke-1 stroke-black circle-icon bg-gray-300"> <use xlink:href="#icon-arrow-left"></use> </svg>
		    </a>

		    <nav aria-label="breadcrumb" class="breadcrumb-holder">
			<ol class="breadcrumb mb-0 pe-3">
			   <li class="breadcrumb-item ">
				<a href="{{route('site.')}}" class="line-height-20">
				    <svg class="icon icon-sm fill-black "> <use xlink:href="#icon-home"></use> </svg>
				</a>
			    </li>
			    <li class="breadcrumb-item"><a href="{{route('site.articles.index')}}">Povești din bucătărie</a></li>
			    <li class="breadcrumb-item active" aria-current="page">{{$article->title}}</li>
			</ol>
		    </nav>

		</div>


		<h1 class="fs-48 fw-700 fw-md-800 mb-2 ">
		    {{$article->title}}
		</h1>

		<div class="fs-14 fw-600">
		    <span>Postat de {{config('app.name')}}</span>   &sdot; <span>{{$article->published_at->diffForHumans('')}}</span>
		</div>
	    </div>

	    <div class="col-md-10 col-lg-8 col-xxl-10 mb-2">
		<div class="post__cover" style="background-image: url('{{$article->getPhotoUrl()}}')"> </div>
	    </div>

	    <div class="col-md-10 col-lg-8">
		<div class="fs-14 mb-4 mb-xl-5">Imagine: <a href="#" target="_blank" class="font-underline">Sursă foto</a></div>

		<div class="post__description">
		    {!! $article->body !!}
		</div>
	    </div>
	</div>
    </div>
</section>

<section class="pt-0">
    <div class="container">
	<div class="row justify-content-center">
	    <div class="col-md-10 col-lg-8">
		<div class="fs-24 fw-700 mb-4">Articole similare</div>

		@if ($articles->count())

                <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 g-3 g-xl-4">
                    @foreach ($articles as $article)
		    @component('site.article.item', compact('article')) @endcomponent
                    @endforeach
                </div>

		@endif
	    </div>
	</div>
    </div>
</section>

@endsection
