<?php /** @var \App\Model\Article $article */ ?>
@extends('layouts.site')
@section('title', $article->title)

@section('content')

    <section class="first-section subheader after"
             style="background-image: url('{{asset('assets/site/images/subheader/subheader-contact.jpg')}}')">
        <div class="container">
            <div class="row">
                <div class="col-md-12 text-center">
                    <div class="subheader__title title-small mb-2 mb-xl-3">
                        @yield('title')
                    </div>

                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('site.')}}">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">@yield('title')</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </section>

    <section class="pt-2 useful-links-page">
        <div class="container mb-xxl-5">
            <div class="row justify-content-center">
                <div class="col-md-12 col-lg-10 col-xl-9">
                    <div class="bg-white px-4 py-4 py-lg-5 p-md-5">
                        <div class="px-xxl-4 py-xxl-5">
                            <div class="mb-4 mb-xl-5">
                                <div class="font-small line-height-25">
                                    {!! $article->body !!}
                                </div>
                                @includeWhen($article->photo_id, 'site.article.page.parts.photos')
                            </div>
                        </div>
                    </div>
                    <div class="text-center">
                        <div class="need-help d-inline-block p-4 bg-white shadow">
                            <div class="title text-uppercase font-base text-secondary letter-spacing-3 font-weight-bold mb-4 px-3 px-md-0">Ai nevoie de suport?</div>
                            <div class="row align-items-center">
                                <div class="col-md-6 mb-3 mb-4 mb-md-0">
                                    <div class="help-box">
                                        <a href="tel:{{config('company.phone_intl_format')}}" class="bg-light d-block p-4">
                                            <img src="{{asset('assets/site/images/icons/call-us.svg')}}" alt="" class="img-fluid mb-2">
                                            <div class="font-xs text-secondary">Sună-ne</div>
                                        </a>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="help-box">
                                        <a href="{{route('site.contact')}}#contact-form" class="bg-light d-block p-4">
                                            <img src="{{asset('assets/site/images/icons/write-us.svg')}}" alt="" class="img-fluid mb-2">
                                            <div class="font-xs text-secondary">Scrie-ne</div>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
