<?php /** @var \App\Model\Article $article */ ?>
@extends('layouts.site')
@section('title', 'Blog')

@section('content')

<section class="blog-subheader py-0">
    <img src="{{asset('assets/site/images/blog-subheader.webp')}}" srcset="{{asset('assets/site/images/blog-subheader.webp')}} 1000w, {{asset('assets/site/images/blog-subheader.webp')}} 1500w" class="img-fluid subheader__img" alt="">
    <div class="container h-100">
	<div class="row h-100 align-items-center">
	    <div class="col-md-12">
		<div class="text-center">
		    <h1 class="fw-700 fw-md-800 fs-48 tracking-tight text-white">Povești din bucătărie</h1>
		</div>
	    </div>
	</div>
    </div>
</section>


<section>
    <div class="container">

            <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 g-3 g-xl-4">
                @forelse ($articles as $article)
                    @component('site.article.item', compact('article'))

                    @endcomponent
                @empty
                    <p class="lead">
                        @lang('No article found').
                    </p>
                @endforelse
            </div>

            @if ($articles->hasPages())
                <div class="row mb-4">
                    <div class="col-md-12">
                        <div class="d-md-flex justify-content-between bg-white align-items-center rounded p-3 text-center">
                            <div>
                                <div class="align-items-center d-flex justify-content-center pagination-bar">
                                    {{$articles->links()}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif

            <div class="row">
                <div class="col-md-12">
                    <div class="googleBanner rounded-lg text-center py-2">
                        @include('site.ads.adsense.4444688418')
                    </div>
                </div>
            </div>
        </div>
    </section>
    @endsection
