<a id="comments"></a>


<div class="fs-24 fw-800 mb-2">Comentarii ({{$reviews->count()}}) </div>


@if ($reviews->count())


@guest
<div class="mb-4">
    Doar utilizatorii întregistrați pot comenta.
    <a href="{{route('login')}}" class="text-orange fw-600">
	Login
    </a>

    sau

    <a href="{{route('register')}}" class="text-orange fw-600">
	cont nou
    </a>
</div>
@endguest

<div class="comment-list">
        @foreach ($reviews as $review)
            <a id="comment-{{$review->id}}"></a>
            <div class="comment">
                <div class="font-weight-medium font-md mb-3">
                    <span class="{{$review->user && $review->user->isAdmin() ? 'text-primary' : ''}}">{{$review->user ? $review->user->getName() : 'user sters'}}</span>
                    @if ($review->user && $review->user->isAdmin())
                        <span class="badge badge-primary">
                            admin
                        </span>
                        @endif
                        &sdot; <span
                                class="font-small font-weight-light text-muted">{{$review->created_at->formatLocalized('%d %B %Y')}}</span>
                </div>

                <div class="comment__content">
                    {!!StringOperation::safeText($review->body)!!}
                </div>

                @if ($review->hasPhoto())
                    <div class="comment__picture mt-2">
                        <a href="{{$review->getPhotoUrl()}}"
                           data-lightbox="comment-photo">
                            <img src="{{$review->getPhotoUrl()}}" alt=""
                                 class="img-fluid">
                        </a>
                    </div>
                @endif
                <button type="button" class="btn btn-link btn-sm p-0 text-secondary show-comment-form"
                        data-parent-id="{{$review->id}}">Răspunde
                </button>
            </div>

            @foreach ($review->children as $review_child)
	    <div class="comment mt-md-n3 mt-lg-n4 border-start border-primary ps-3 ms-3 ms-md-5">
		<div class="font-weight-medium font-md mb-3">
                        <span class="{{$review_child->user && $review_child->user->isAdmin() ? 'text-primary' : ''}}">
                            {{$review_child->user ? $review_child->user->getName() : 'user sters'}}
                        </span>
                        @if ($review_child->user && $review_child->user->isAdmin())
                            <span class="badge badge-primary">
                            admin
                        </span>
                            @endif
                            &sdot; <span
                                    class="font-small font-weight-light text-muted">{{$review_child->created_at->formatLocalized('%d %B %Y')}}</span>
                    </div>

                    <div class="comment__content">
                        {!!StringOperation::safeText($review_child->body)!!}
                    </div>

                    @if ($review_child->hasPhoto())
                        <div class="comment__picture mt-2">
                            <a href="{{$review_child->getPhotoUrl()}}"
                               data-lightbox="comment-photo">
                                <img src="{{$review_child->getPhotoUrl()}}" alt=""
                                     class="img-fluid">
                            </a>
                        </div>
                    @endif
                </div>
            @endforeach
        @endforeach
    </div>
@else
<div class="text-danger font-weight-medium mb-4">
    Nici un comentariu pentru această postare. Fii primul!
    </div>
@endif




<div class="leave-comment @guest d-none @endguest"
     id="review-form">
    @auth
        <form
                enctype="multipart/form-data"
                action="{{route('site.article.review.store', $article)}}"
                method="POST"
                class="form-review">
            @csrf
            <label class="has-float-label mb-4">
                                            <textarea class="form-control h-auto pt-4"
                                                      name="body"
                                                      rows="6" required=""
                                                      placeholder="&nbsp;"></textarea>
                <span>Mesajul tău...</span>
            </label>

            <input type="hidden" name="parent_id" value="0">

            <label class="has-float-label mb-4 type-file">
                <input type="file" class="form-control cursor-pointer px-2 py-3" name="photo"
                       placeholder="&nbsp;" style="opacity: 1;">
                <span>Adaugă poză</span>
            </label>

            {{--            <div class="row mb-4">--}}
            {{--                <div class="col-md-6">--}}
            {{--                    <div class="form-group">--}}
            {{--                        <label class="has-float-label">--}}
            {{--                            <input type="text" class="form-control" name="comment-name"--}}
            {{--                                   required="" placeholder="&nbsp;">--}}
            {{--                            <span>Nume</span>--}}
            {{--                        </label>--}}
            {{--                    </div>--}}
            {{--                </div>--}}

            {{--                <div class="col-md-6">--}}
            {{--                    <div class="form-group">--}}
            {{--                        <label class="has-float-label">--}}
            {{--                            <input type="email" class="form-control" name="comment-email"--}}
            {{--                                   required="" placeholder="&nbsp;">--}}
            {{--                            <span>Email</span>--}}
            {{--                        </label>--}}
            {{--                    </div>--}}
            {{--                </div>--}}
            {{--            </div>--}}

            @include('site.parts.approve_gdpr')

            <p class="small text-muted">
                Numele va fi public la postare.
            </p>
            <button type="submit" class="btn btn-custom btn-primary">
                <span class="letter-spacing-08">Trimite</span>
            </button>

        </form>
    @endauth
    @guest
        <div class="alert alert-warning">
            Trebuie să fii autentificat pentru a publica un comentariu.
        </div>
    @endguest
</div>


<script>
    $('.show-comment-form').click(function () {
        var $injected_form = $(this).siblings('form');
        if ($injected_form.length) {
            if (!$injected_form.find('textarea').val()) {
                $(this).siblings('form').remove();
            }
            return;
        }
        $('.comment-list form').hide();
        $form = $('#review-form').children().clone();
        $form.addClass('small my-3 border-left border-primary pl-3 ml-3 ml-md-5 leave-comment').find('input[name=parent_id]').val(this.dataset.parentId);
        $(this).after($form);
        fpro();
    })
</script>