@extends('layouts.site')
@section('title', 'Contul meu')
@section('breadcrumb', 'Contul meu')

@section('content')
<section class="pb-4">
    <div class="container">

	    <div class="row">
		<div class="col-md-12">
		    <div class="bg-gray-200 rounded-md admin-header px-4 py-4 py-md-5">
			<div class="row align-items-center">
			    <div class="col-md-6 mb-4 mb-md-0">
				<div class="fs-24 fw-600 mb-md-3">
				    Salut {{auth()->user()->getName()}},
				</div>

				<div class="d-flex align-items-center">
				    <span class="fs-36 fw-800 me-3">Bine ai revenit</span>
				    <svg class="icon icon-lg fill-gray-600 stroke-1 stroke-gray-600 me-2">
					<use xlink:href="#icon-waving-hand"></use>
					</svg>
				</div>
			    </div>

			    <div class="col-md-6">
				<div class="text-md-end">
				    <a class="btn btn-custom px-3 py-2 w-100 w-md-auto" href="{{route('logout')}}">
					<span class="px-3 py-1 d-inline-block fw-600 ">Logout</span>
				    </a>
				</div>
			    </div>
			</div>
		    </div>
		</div>
	    </div>
        </div>
    </section>

    <section>
        <div class="container">
            <div class="row mb-2 mb-md-4">
                <div class="col-md-12">
                    <h1 class="fs-24 fw-700">Rețete cu care ai reacționat</h1>
                </div>

            </div>

            <div class="row row-cols-1 row-cols-md-2 row-cols-lg-3 row-cols-xl-4 g-3 g-xl-4">
                @forelse ($articles as $article)
		<div class="col category-holder">

		    <div class="recipe--grid">
			<a href="{{$article->getRecipeUrl()}}" class="a-absolute"></a>
			<div class="recipe__img mb-2 mb-md-3 ratio ratio-4x5">
			    <img src="{{$article->getThumbUrl()}}" alt="{{$article->title}}" class="img-fluid"
				 loading="lazy">
			</div>

			<div class="recipe__category">
			    {{$recipe->category->name ?? ''}}
			</div>
			<a href="{{$article->getRecipeUrl()}}" class="recipe__name">
			    {{$article->title}}
			</a>
		    </div>
		</div>
                @empty
                    <p class="lead md-12 mx-3">
                        @lang('No article found').
                    </p>
                @endforelse
            </div>

            @if ($articles->hasPages())
                <div class="d-md-flex justify-content-between align-items-center text-center">
                    <div>
                        <div class="align-items-center d-flex justify-content-center pagination-bar">
                            {{$articles->links()}}
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>
@endsection
