@extends('layouts.client')
@section('title', 'Modifică adresă')

@section('subcontent')
    <div class="font-md font-weight-semibold mb-4">
        Adresă
    </div>

    <form
            class="pt-xl-2"
            action="{{route('client.contacts.update', $contact->id)}}"
            method="POST">

        {{csrf_field()}}

        <input type="hidden" name="__id"
               value="{{old('id', $contact->id)}}">

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Nume</label>
                    <input type="text" name="lastname"
                           value="{{old('lastname', $contact->lastname)}}"
                           class="form-control" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Prenume</label>
                    <input type="text" name="firstname"
                           value="{{old('firstname', $contact->firstname)}}"
                           class="form-control" required>
                </div>
            </div>
        </div>

        <div class="row account-basic">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email"
                           value="{{old('email', $contact->email)}}"
                           class="form-control" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Telefon</label>
                    <input type="text" name="phone"
                           value="{{old('phone', $contact->phone)}}"
                           class="form-control" required>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label>Adresa</label>
                    <input type="text" name="address"
                           value="{{old('address', $contact->address)}}"
                           class="form-control" required>
                </div>
            </div>
            {{--                    <div class="col-md-3">--}}
            {{--                        <div class="form-group">--}}
            {{--                            <label>Cod poștal</label>--}}
            {{--                            <input type="text" name="postalcode"--}}
            {{--                                   value="{{old('postalcode', $contact->postalcode)}}"--}}
            {{--                                   class="form-control">--}}
            {{--                        </div>--}}
            {{--                    </div>--}}
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label>Județ</label>
                    <select class="form-control" name="county_id" required>
                        @foreach ($counties as $id => $county)
                            <option value="{{$id}}" {{ !empty($contact->county_id) && $contact->county_id == $id || old('county_id') == $id ? 'selected' :'' }}>
                                {{$county}}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Oraș</label>
                    <input type="text" name="city"
                           value="{{old('city', $contact->city)}}"
                           class="form-control" required>
                </div>
            </div>
        </div>

        @if ($contact->isCompany())
            <div class="font-md font-weight-semibold mb-4 mt-5">
                Date firma
            </div>
            <div class="row">
                <div class="col-md-6 form-group">
                    <label>Denumire firma

                    </label>
                    <input type="text" name="company_name"
                           value="{{old('company_name',$contact->company_name)}}"
                           class="form-control not-required">
                </div>
                <div class="col-md-6 form-group">
                    <label>CUI Firma


                    </label>
                    <input type="text" name="company_cui"
                           value="{{old('company_cui',$contact->company_cui)}}"
                           class="form-control not-required">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 form-group">
                    <label>Nr reg. com.

                    </label>
                    <input type="text" name="company_reg"
                           value="{{old('company_reg',$contact->company_reg)}}"
                           class="form-control not-required">
                </div>
                <div class="col-md-6 form-group">
                    <label>Cont Bancar

                    </label>
                    <input type="text" name="bankaccount"
                           value="{{old('bankaccount',$contact->bankaccount)}}"
                           class="form-control not-required">
                </div>
            </div>
        @endif

        <div class="pt-2">
            <button type="submit" class="btn btn-secondary rounded-md py-2 px-4">
                <span class="font-weight-semibold font-xs px-2">Salvează</span>
            </button>

        </div>
    </form>
@endsection
