@extends('layouts.site')

@section('content')
<section class="login-register-section ">
    <img src="{{asset('assets/site/images/login-register-bg.webp')}}" srcset="{{asset('assets/site/images/login-register-bg.webp')}} 1000w, {{asset('assets/site/images/login-register-bg.webp')}} 1500w" class="img-fluid section__img" alt="">
    <div class="container">
	<div class="row justify-content-center">
	    <div class="col-md-9 col-lg-7 col-xl-5 col-xxl-6">
		<div class="login-register-form px-4 px-md-5 py-5 mx-md-4">
		    <div class="px-md-2">
			<div class="text-center mb-4 mb-xl-5">
			    <div class="fw-700 fw-md-800 fs-36 mb-2">Cont nou</div>
			    <div class="fw-600 fs-24">Înregistrare pe Superchef</div>
			</div>

			<div>
			    <a href="#" class="btn btn-block btn-outline-black rounded-pill d-flex align-items-center justify-content-center border border-black border-2 mb-3 py-2">
				<svg class="icon icon-sm fill-facebook-blue me-2"> <use xlink:href="#icon-facebook-circle"></use> </svg>
				<span class="fw-700">Înregistrare cu Facebook</span>
			    </a>

			    <a href="#" class="btn btn-block btn-outline-black rounded-pill d-flex align-items-center justify-content-center border border-black border-2 py-2">
				<svg class="icon icon-sm me-2"> <use xlink:href="#icon-google"></use> </svg>
				<span class="fw-700">Înregistrare cu Google</span>
			    </a>
			</div>

			<div class="my-5 d-flex align-items-center justify-content-center">
			    <span class="border flex-grow-1"></span>
			    <span class="mx-4">sau înregistrare cu email</span>
			    <span class="border flex-grow-1"></span>
			</div>

			<div>
			    @include('auth.3rdparty')
			    <form class="form-horizontal pt-30" method="POST" action="{{ route('register') }}">
				 @csrf

				<div class="form-group mb-3">

				    <label class="has-float-label">
					<input id="name" type="text" class="form-control{{ $errors->has('name') ? ' is-invalid' : '' }}"
					       name="name" value="{{ old('name') }}" required placeholder="&nbsp;">
					<span>{{ __('Name') }}</span>
				    </label>

				    @if ($errors->has('name'))
					    <span class="invalid-feedback" role="alert">
					    <strong>{{ $errors->first('name') }}</strong>
					</span>
				    @endif
				</div>

				<div class="form-group mb-3">

				    <label class="has-float-label">
					<input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}"
					       name="email" value="{{ old('email') }}" required placeholder="&nbsp;" >
					<span>{{ __('Email Address') }}</span>
				    </label>

				   @if ($errors->has('email'))
					    <span class="invalid-feedback" role="alert">
					    <strong>{{ $errors->first('email') }}</strong>
					</span>
					@endif
				</div>

				<div class="form-group">

				    <div class="password-field">
					<label class="has-float-label mb-2 input-holder-pass">
					    <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}"
						   name="password" required placeholder="&nbsp;">

					    <span>{{ __('Password') }}</span>

					    <div class="see-password me-3">
						<input type="checkbox" class="toggle-visibility cursor-pointer">
						<div class="icon-holder">
						    <svg class="icon icon-sm fill-gray-600"> <use xlink:href="#icon-eye"></use></svg>
						</div>
					    </div>
					</label>
				    </div>

				    @if ($errors->has('password'))
                                        <span class="invalid-feedback" role="alert">
                                        <strong>{{ $errors->first('password') }}</strong>
                                    </span>
                                    @endif

				</div>

				 <div class="form-group mb-4">

				    <div class="password-field">
					<label class="has-float-label mb-2 input-holder-pass">
					   <input id="password-confirm" type="password" class="form-control"
					       name="password_confirmation" required placeholder="&nbsp;">

					    <span>{{ __('Confirm Password') }}</span>

					    <div class="see-password me-3">
						<input type="checkbox" class="toggle-visibility cursor-pointer">
						<div class="icon-holder">
						    <svg class="icon icon-sm fill-gray-600"> <use xlink:href="#icon-eye"></use></svg>
						</div>
					    </div>
					</label>
				    </div>

				</div>

                                @include('site.parts.approve_gdpr')

				<button type="submit" class="btn btn-custom w-100 mb-4 mb-xl-5 mt-4">
				    {{ __('Register') }}
				</button>

				<div class="text-center fw-600">
				    Ai deja cont?
				    <a class="text-orange mt-2" href="{{route('login')}}">
					Log in
                                    </a>
				</div>
			    </form>
			</div>
		    </div>
		</div>
	    </div>
	</div>
    </div>
</section>

@endsection
