@extends('layouts.admin')
@section('title', 'Videos')


@section('actions')
<a href="{{route('admin.videos.create')}}" class="btn btn-primary m-md">
    <i class="fa fa-plus-circle"></i>
    adauga video
</a>
@endsection

@section('content')
<div class="ibox">
    <div class="ibox-content">
        <table class="table table-striped-or-not table-hover">
            <thead>
                <tr>
                    <th data-sort-ignore="true" style="width: 1%"></th>

                    <th>Nume</th>
                    <th class="text-right">Actiuni</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($videos as $video)
                <tr role="button">
                    <td>

                        <img src="{{$video->getPhotoUrl()}}" style="width: 32px; height:32px; object-fit: contain" />

                    </td>
                    <td>

                        {{$video->youtube_id}}
                    </td>
                    <td class="text-right">
                        <div class="modal" id="item-{{$video->id}}" tabindex="-1" role="dialog"  aria-hidden="true">
                            <div class="modal-dialog text-left" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                        <h4 class="modal-title">Stergere obiect</h4>
                                    </div>
                                    <div class="modal-body text-left">

                                        <p>
                                            Sigur doriti sa stergeti acest video?
                                        </p>


                                    </div>
                                    <div class="modal-footer">
                                        <form action="{{route('admin.videos.destroy', $video)}}" method="POST">
                                            {{ method_field('DELETE') }}
                                            {{ csrf_field() }}
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Anuleaza</button>

                                            <input type="submit" value="sterge" class="btn btn-danger" />    

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <a href="{{route('admin.videos.edit', $video)}}" class="btn btn-edit btn-xs btn-success">edit</a>
                        <a href="#" class="btn btn-xs btn-danger" data-toggle="modal" data-target="#item-{{$video->id}}">sterge</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table> 
    </div>
</div>
@endsection
