@extends('layouts.admin')
@section('title', $video->exists ? "Editare {$video->name}" : 'Adaugare video youtube')

@section('content')

    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>

        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <form action="{{route($video->exists ? 'admin.videos.update' : 'admin.videos.store', $video)}}" method="POST" class="form-horizontal">
                        @csrf
                        {{ method_field($video->exists ? 'PUT' : 'POST' ) }}

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Cod/Video Youtube</label>
                            <div class="col-sm-10">
                                <input type="text" name="youtube_id"
                                       autocomplete="off"
                                       value="{{ (old('youtube_id')) ?: $video->youtube_id }}" class="form-control"
                                       autofocus="autofocus" required/>
                                <p class="text-muted m-t">
                                    Introduceti cod-ul de la video youtube de forma <b>eY_4LlBWJX4</b> sau link url
                                    complet,
                                    exemplu https://www.youtube.com/watch?v=<b>eY_4LlBWJX4</b>
                                </p>

                                @if ($video->exists)
                                    <iframe width="560" height="315"
                                            src="https://www.youtube.com/embed/{{$video->youtube_id}}" frameborder="0"
                                            allow="autoplay; encrypted-media" allowfullscreen></iframe>
                                @endif

                            </div>
                        </div>

                        <div class="hr-line-dashed"></div>


                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">Salveaza</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>


    </div>

@endsection
