@extends('layouts.admin')
@section('title', 'Date cont si adrese')

@section('content')
    <div class="row">
        <div class="col-lg-6">
            <div class="ibox">
                <div class="ibox-title">
                    <h1>
                        Cont
                    </h1>
                </div>
                <div class="ibox-content">

                    <p class="mb-1">
                        <span class="text-muted">Inregistrat:</span> {{$user->created_at}}
                    </p>
                    <p class="mb-1">
                        <span class="text-muted">Email:</span> {{$user->email}}
                    </p>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        @if ($user->deliveryContact)
            <div class="col-lg-6">
                <div class="ibox">
                    <div class="ibox-title">
                        <h1>
                            Adresa livrare
                        </h1>
                    </div>
                    <div class="ibox-content">

                            <p class="mb-1">
                                <span class="text-muted">Nume si Prenume:</span> {{$user->deliveryContact->getName()}}
                            </p>
                        <p class="mb-1">
                            <span class="text-muted">Adresa:</span> {{$user->deliveryContact->address}}
                            , {{$user->deliveryContact->postalcode}}, {{$user->deliveryContact->city}}
                            , {{$user->deliveryContact->county->name}}.
                        </p>
                        <p class="mb-1">
                            <span class="text-muted">Telefon:</span> {{$user->deliveryContact->phone}}
                        </p>
                        <p class="mb-1">
                            <span class="text-muted">Email:</span> {{$user->deliveryContact->email ?? $user->email}}
                        </p>
                    </div>
                </div>
            </div>



            @if ($user->billingContact)
                <div class="col-lg-6">
                    <div class="ibox">
                        <div class="ibox-title">
                            <h1>
                                Adresa facturare
                            </h1>
                        </div>
                        <div class="ibox-content">

                            @if ($user->billingContact->type == 'company')
                                <p class="mb-1">
                                    <span class="text-muted">Nume firmă:</span> {{$user->billingContact->company_name}}
                                </p>
                                <p class="mb-1">
                                    <span class="text-muted">CUI:</span> {{$user->billingContact->company_cui}}
                                </p>
                                <p class="mb-1">
                                    <span class="text-muted">Nr reg. com.:</span> {{$user->billingContact->company_reg}}
                                </p>
                                <p class="mb-1">
                                    <span class="text-muted">Cont bancar:</span> {{$user->billingContact->bankaccount}}
                                </p>
                            @endif

                            {{--                        <p class="mb-1">--}}
                            {{--                            <span class="text-muted">Nume si Prenume:</span> {{$user->billingContact->getName()}}--}}
                            {{--                        </p>--}}
                            <p class="mb-1">
                                <span class="text-muted">Adresa:</span> {{$user->billingContact->address}}
                                , {{$user->billingContact->postalcode}}, {{$user->deliveryContact->city}}
                                , {{$user->deliveryContact->county->name}}.
                            </p>
                        </div>
                    </div>
                </div>
            @endif
        @endif
    </div>
@endsection
