@extends('layouts.admin')
@section('title', $review->exists ? "Editare {$review->name}" : 'Creare review nou')

@section('content')

    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De baza</a></li>

        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <form action="{{route('admin.reviews.update', $review)}}" method="POST" class="form-horizontal">

                        {{ method_field($review->exists ? 'PUT' : 'POST' ) }}
                        {{ csrf_field() }}

                        @if ($review->user)
                            <p>
                                {{--                        Reviewul a fost postat de un user inregistrat: --}}
                                Autor:
                                <a href="{{route('admin.users.edit', $review->user)}}">
                                    {{$review->user->getName()}}
                                </a>
                            </p>
                        @else
                            <div class="form-group">
                                <label class="col-sm-2 control-label">Nume</label>
                                <div class="col-sm-10">
                                    <input type="text" name="name" value="{{ (old('name')) ?: $review->name }}"
                                           class="form-control" autofocus="autofocus" required/>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-sm-2 control-label">Email</label>
                                <div class="col-sm-10">
                                    <input type="text" name="email" value="{{ (old('email')) ?: $review->email }}"
                                           class="form-control" autofocus="autofocus" required/>
                                </div>
                            </div>
                        @endif


                        <div class="form-group">
                            <label class="col-sm-2 control-label">Mesaj</label>
                            <div class="col-sm-10">
                                <textarea required class="form-control" rows="8"
                                          name="body"> {{ (old('body')) ?: $review->body }}</textarea>
                            </div>
                        </div>

                        @if ($review->hasPhoto())
                            <p>
                                Poza:
                            </p>
                            <img src="{{$review->getPhotoUrl()}}" style="max-width: 200px" />
                        @endif

                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">Salveaza</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

        </div>


    </div>

@endsection
