@extends('layouts.admin')
@section('title', 'Admin Dashboard')

@section('content')
    <div class="container">
        <div class="row">
            <div class="col-md-8 col-md-offset-2">
                <div class="panel panel-default">
                    <div class="panel-heading">Important</div>

                    <div class="panel-body">
                        @if (session('status'))
                            <div class="alert alert-success">
                                {{ session('status') }}
                            </div>
                        @endif


                        <p>
                            Din meniu alegeti sectiunile disponibile pt administrare.
                        </p>

                        <div class="fa-2x">
                            <p class="text-uppercase small font-bold">
                                Retete
                            </p>

                            <ul>
                                <li>
                                    <a href="{{route('admin.articles.index', ['parent_id' => config('categories_mapping.recipes')])}}">
                                        Administrare retete
                                    </a>
                                </li>
                                <li>
                                    <a href="{{route('admin.articles.create', ['parent_id' => config('categories_mapping.recipes')])}}">
                                        Adauga reteta noua
                                    </a>
                                </li>
                            </ul>

                            <p class="m-t text-uppercase small font-bold">
                                Articole blog
                            </p>

                            <ul>
                                <li>
                                    <a href="{{route('admin.articles.index', ['category_id' => config('categories_mapping.articles'), 'root_it' => config('categories_mapping.articles')])}}">
                                        Administrare articole
                                    </a>
                                </li>
                                <li>
                                    <a href="{{route('admin.articles.create', ['category_id' => config('categories_mapping.articles')])}}">
                                        Adauga articol blog
                                    </a>
                                </li>
                            </ul>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
