@extends('layouts.admin')
@section('title', 'Regiuni')

@section('actions')
    {{--    <a href="{{route('admin.galleries.index', ['sortable' => true])}}" class="btn btn-success m-md">--}}
    {{--        <i class="fa fa-refresh"></i>--}}
    {{--        sortare featured--}}
    {{--    </a>--}}
    <a href="{{route('admin.galleries.create')}}" class="btn btn-primary m-md">
        <i class="fa fa-plus-circle"></i>
        adauga
    </a>
@endsection

@section('content')
    <style>
        table td {
            vertical-align: middle !important;
        }
    </style>
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-content">
                    <table class="table table-stripped toggle-arrow-tiny table-hover table-action " data-page-size="50"
                           data-filtering="true">
                        <thead>
                        <tr>
                            <th data-sort-ignore="true" style="width: 1%" class="text-nowrap">
                                #
                            </th>


                            <th data-toggle="true">Nume</th>
                            <th data-toggle="true">Ordine</th>
{{--                            <th class="text-nowrap">Recomandat--}}
{{--                            </th>--}}

                            <th class="text-nowrap">Stare
                            </th>
                            <th class="text-right" data-sort-ignore="true">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($galleries as $gallery)
                            <tr>
                                <td>
                                    @if ($gallery->photo)
                                        <img src="{{$gallery->photo->getThumbUrl()}}"
                                             style="width: 64px; height:64px; object-fit: cover"/>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{route('admin.galleries.edit', $gallery)}}">{{ $gallery->name }}</a>
                                </td>
                                <td>
                                    {{$gallery->priority}}
                                </td>
{{--                                <td>--}}
{{--                                     <span class="badge badge-{{$gallery->is_featured ? 'success' : 'bg-muted'}}">--}}
{{--                                        {{$gallery->is_featured ? 'da' : 'nu'}}--}}
{{--                                    </span>--}}
{{--                                </td>--}}

                                <td>
                                    <span class="badge badge-{{$gallery->status_class}}">
                                        {{$gallery->status}}
                                    </span>
                                </td>

                                <td class="text-right">
                                    <div class="btn-group text-nowrap">

                                        <form action="{{route('admin.galleries.destroy', $gallery)}}" class="inline"
                                              method="POST">
                                            {{ method_field('DELETE' ) }}
                                            {{ csrf_field() }}
                                            <a href="{{$gallery->getUrl()}}" class="btn-white btn btn-xs"
                                               target="_blank">vezi</a>
                                            <a href="{{route('admin.galleries.edit', $gallery)}}"
                                               class="btn-success btn btn-xs btn-edit">edit</a>
                                            <button type="submit" class="btn btn-xs btn-delete btn-danger"
                                                    onclick="return confirm('sigur stergeti?')">
                                                sterge
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="6">
                                <ul class="pagination pull-right"></ul>
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                    {{$galleries->links('vendor.pagination.bootstrap')}}
                </div>
            </div>
        </div>
    </div>
@endsection
