@extends('layouts.admin')
@section('title', $gallery->exists ? $gallery->name : 'Adaugare entitate noua')

@section('content')
    <div class="tabs-container">
        <ul class="nav nav-tabs">
            <li class="active"><a data-toggle="tab" href="#tab-1" aria-expanded="true">De bază</a></li>
            @if ($gallery->exists)
                <li class=""><a data-toggle="tab" href="#tab-5" aria-expanded="false">Poze</a></li>
{{--                <li class=""><a href="{{$gallery->getUrl()}}" target="_blank">Preview articol</a></li>--}}
            @endif
        </ul>
        <div class="tab-content">
            <div id="tab-1" class="tab-pane active">
                <div class="panel-body">
                    <form action="{{route($gallery->exists ? 'admin.galleries.update' : 'admin.galleries.store', $gallery)}}"
                          method="POST" class="form-horizontal">
                        @method($gallery->exists ? 'PUT' : 'POST')
                        @csrf

                        <input type="hidden" name="_redirect" value="{{url()->previous()}}" class="form-control">

                        @if (!$gallery->exists)
                            <p class="text-center h3 text-primary" style="padding-bottom: 24px">
                                Alegeti un nume pentru entitate si continuati.
                            </p>
                        @endif

                        <div class="row">
                            <div class="col-md-8 col-lg-8">
                                <div class="form-group">
                                    <label class="col-sm-2 control-label">Nume
                                    </label>
                                    <div class="col-sm-10">
                                        <input type="text" name="name"
                                               value="{{ ((old('name')) ?: $gallery->{'name'}) }}"
                                               class="form-control" autofocus="autofocus" required>
                                    </div>
                                </div>


                                @if ($gallery->exists)
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">Url vinuri
                                        </label>
                                        <div class="col-sm-10">
                                            <input type="text" name="url"
                                                   value="{{ ((old('url')) ?: $gallery->{'url'}) }}"
                                                   class="form-control">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label class="col-sm-2 control-label">
                                            Descriere
                                        </label>
                                        <div class="col-sm-10">
                                                        <textarea name="description" class="form-control rich"
                                                                  rows="8">
                                                            {{ (old('description')) ?: $gallery->{'description'} }}
                                                        </textarea>
                                        </div>
                                    </div>
                                @endif
                            </div>
                            <div class="col-md-4 col-lg-4">
                                <div class="ibox">
                                    <div class="ibox-content bg-muted">
                                        <div class="form-group">
                                            <label class="col-sm-3 control-label">Prioritate</label>
                                            <div class="col-sm-9">
                                                <input
                                                        value="{{$gallery->priority ?? 9999}}"
                                                        type="number"
                                                        class="form-control" name="priority">
                                            </div>
                                        </div>
                                        @if ($gallery->exists)
                                            <div class="form-group">
                                                <label class="col-sm-3 control-label {{$gallery->status === 'active' ? 'text-primary' : 'text-danger'}}">Status</label>
                                                <div class="col-sm-9">
                                                    <select name="status" class="form-control">
                                                        @foreach ($gallery->getPossibleEnumValues('status') as $value)
                                                            <option value="{{$value}}"
                                                                    {{ $gallery->status == $value ? 'selected=selected' : '' }}>
                                                                {{$value}}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        @endif




                                        {{--                                        <div class="form-group">--}}
                                        {{--                                            <label class="checkbox-inline col-sm-9 col-sm-offset-3">--}}
                                        {{--                                                <input type="hidden" name="is_featured" value="0"/>--}}
                                        {{--                                                <input type="checkbox" name="is_featured" value="1" class="i-checks"--}}
                                        {{--                                                       @if ($gallery->is_featured)--}}
                                        {{--                                                       checked="checked"--}}
                                        {{--                                                        @endif--}}
                                        {{--                                                /> Apare la Recomandate--}}
                                        {{--                                            </label>--}}
                                        {{--                                        </div>--}}

                                    </div>
                                </div>

                            </div>
                        </div>


                        <div class="hr-line-dashed"></div>
                        <div class="form-group">
                            <div class="col-sm-4 col-sm-offset-2">
                                <button class="btn btn-primary" type="submit">
                                    @if ($gallery->exists)
                                        Salveaza
                                    @else
                                        Salveaza si Continua
                                    @endif
                                </button>
                            </div>
                        </div>
                        @if ($gallery->exists && false)
                            @include('admin.parts.photo.input_info')
                        @endif
                    </form>
                </div>
            </div>
            <div id="tab-5" class="tab-pane">
                <div class="panel-body">
                    @includeWhen($gallery->exists, 'admin.parts.photo.index')
                </div>
            </div>
        </div>
    </div>
    @include('admin.parts.rich_editor', ['can_browse_photos' => false, 'height' => 150])
    <script>
        @if (request('tab') === 'files')
        $('.nav-tabs a[href="#files"]').tab('show');
        @endif
    </script>
@endsection