@extends('layouts.admin')
@section('title', 'Covers')


@section('actions')
    <a href="{{route('admin.covers.create')}}" class="btn btn-primary m-md">
        <i class="fa fa-plus-circle"></i>
        adauga cover
    </a>
@endsection

@section('content')
    <div class="ibox">
        <div class="ibox-content table-responsive">
            <table class="table table-striped-or-not table-hover">
                <thead>
                <tr>
                    <th>Poza</th>
                    <th>Activ</th>
                    <th>Ordine</th>
                    <th class="text-right">Actiuni</th>
                </tr>
                </thead>
                <tbody>
                @foreach ($covers as $cover)
                    <tr role="button">

                        <td>
                            <p class="small">
                                {{$cover->filename}}
                            </p>

                            @if ($cover->filename)
                                <img src="{{$cover->getPhotoUrl()}}"
                                     style="max-height: 150px; object-fit: contain"/>
                            @endif
                        </td>

                        <td>
                            <span class="badge badge-{{$cover->is_active ? 'success' : 'danger'}}">
                                {{$cover->is_active ? 'da' : 'nu'}}
                            </span>
                        </td>

                        <td>
                            {{$cover->priority}}
                        </td>
                        <td class="text-right">
                            <div class="modal" id="item-{{$cover->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                                <div class="modal-dialog text-left" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                            <h4 class="modal-title">Stergere obiect</h4>
                                        </div>
                                        <div class="modal-body text-left">
                                            <p>
                                                Sigur doriti sa stergeti?
                                            </p>
                                        </div>
                                        <div class="modal-footer">
                                            <form action="{{route('admin.covers.destroy', $cover)}}" method="POST">
                                                {{ method_field('DELETE') }}
                                                {{ csrf_field() }}
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                                                    Anuleaza
                                                </button>
                                                <input type="submit" value="sterge" class="btn btn-danger"/>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <form action="{{route('admin.covers.update', $cover)}}" method="POST">
                                {{ method_field('PUT') }}
                                {{ csrf_field() }}
                                <input type="hidden" name="is_active" value="{{(int)!$cover->is_active}}"/>
                                <input type="submit" value="{{$cover->is_active ? 'dezactiveaza' : 'activeaza'}}"
                                       class="btn btn-xs {{$cover->is_active ? 'btn-warning' : 'btn-success'}}"/>

                                <a href="{{route('admin.covers.edit', $cover)}}"
                                   class="btn btn-edit btn-xs btn-success">edit</a>
                                <a href="#" class="btn btn-xs btn-danger" data-toggle="modal"
                                   data-target="#item-{{$cover->id}}">sterge</a>
                            </form>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
