@isset($category)
    <tr role="button-or-not" class="{{$category->parent_id ?: 'bg-light'}}">
        <td style="padding-left: {{$depth * 5 * 10}}px">
        {{--        {!!str_repeat('&nbsp;', $depth * 5)!!}--}}

        <!--⋅-->


            <a href="{{route('admin.categories.edit', $category)}}"
               class="{{$category->parent_id == 0 ? 'font-bold h4' : ''}}">
                @if ($category->photo)
                    <img src="{{$category->getPhotoUrl()}}" style="width: 48px; height:48px; object-fit: contain"/>
                @endif
                {{ $category->name }}
            </a>

            @if (!$category->parent_id && $category->show_in_menu)
                <span class="badge badge-primary">
            apare in meniu
        </span>
            @endif
        </td>

        <td>
        <span class="badge badge-{{$category->is_active ? 'success' : 'danger'}}">
            {{$category->is_active ? 'activ' : 'inactiv'}}
        </span>
        </td>

        @if (!request('show_ids'))

            <td style="width: 100px">
                <input class="form-control priority" value="{{$category->priority}}"
                       name="priority[{{$category->id}}]"/>
            </td>

            <td class="text-right">
                <div class="modal" id="item-{{$category->id}}" tabindex="-1" role="dialog" aria-hidden="true">
                    <div class="modal-dialog text-left" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h4 class="modal-title">Stergere obiect</h4>
                            </div>
                            <div class="modal-body text-left">
                                @if ($category->can_be_deleted)

                                    <p>
                                        Sigur doriti sa stergeti acesta categorie?
                                    </p>
                                    <p>
                                        Atentie, articolele care au fost asociate pe aceasta cateogrie vor ramane
                                        nelistate!
                                        De asemenea, toate subcategoriile vor disparea.
                                    </p>
                                @else
                                    <p>
                                        Aceasta categorie nu poate fi stearsa, e rezervata pentru sistem.
                                    </p>
                                @endif
                            </div>
                            @if ($category->can_be_deleted)
                                <div class="modal-footer">
                                    <form action="{{route('admin.categories.destroy', $category)}}" method="POST"
                                          style="display: inline-block">
                                        {{ method_field('DELETE') }}
                                        {{ csrf_field() }}
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Anuleaza
                                        </button>
                                        <input type="submit" value="sterge" class="btn  btn-danger"/>
                                    </form>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>


                {{--                @if ($category->parent_id === 0 || $depth <= 0)--}}
                @if ($category->can_have_children && $depth <= 0)
                    {{--                    just 1 level homeboi--}}
                    <a href="{{route('admin.categories.create', ['parent_id' => $category->id])}}"
                       class="btn btn-primary {{$depth === 0 ? 'btn-whatever' : 'btn-xs '}}">adauga</a>
                @endif
                <a href="{{route('admin.categories.edit', $category)}}"
                   class="btn btn-edit-or-not btn-success  {{$depth === 0 ? 'btn-whatever' : 'btn-xs '}}">edit</a>
                <a href="#"
                   class="btn btn-danger  {{$depth === 0 ? 'btn-whatever' : 'btn-xs '}}  {{$category->can_be_deleted ? '' : 'disabled'}}" data-toggle="modal"
                   data-target="#item-{{$category->id}}">sterge</a>
            </td>
        @else
            <td>
                @if (!count($category->subcats))
                    {{$category->id}}
                @else
                    -
                @endif
            </td>


        @endif
    </tr>
@endif

@if (!empty($categories) && count($categories))
    @foreach ($categories as $category)

        @component('admin.category.items', ['categories' => $category->subcats, 'category' => $category, 'depth' => $category->depth ])

        @endcomponent
    @endforeach
@endif