@extends('layouts.admin')
@section('title')
    {{$parent->name ?? $category->path ?? $category->name ?? 'Toate Articolele'}}
@endsection

@section('actions')
    {{--    <a href="{{route('admin.articles.index', ['sortable' => true])}}" class="btn btn-success m-md">--}}
    {{--        <i class="fa fa-refresh"></i>--}}
    {{--        sortare featured--}}
    {{--    </a>--}}
    @if (!$category || $category && $category->can_create_articles)
        <a href="{{route('admin.articles.create', ['category_id' => $category->id ?? '', 'parent_id' => request('parent_id') ?? ''])}}"
           class="btn btn-primary m-md">
            <i class="fa fa-plus-circle"></i>
            adauga
        </a>
    @endif

@endsection

@section('content')
    <div class="ibox-content m-b-sm border-bottom filters-n-stuff anim">

        <div class="row">
            <div class="col-sm-12 col-md-6 col-lg-7">
                <form action="{{route('admin.articles.index')}}" method="GET">
                    <div class="form-group">
                        <label class="control-label">Cautare in articole. Apasati enter</label>
                        <input type="text" name="q" value="" placeholder="Ce cautati?" class="form-control">
                        @foreach (request()->except(['page', 'q']) as $key => $value)
                            <input type="hidden" name="{{$key}}" value="{{$value}}">
                        @endforeach
                    </div>
                </form>
            </div>


            @if (auth()->user()->isSuperAdmin() || request('parent_id'))
                <div class="col-sm-12 col-md-6 col-lg-5">
                    <form action="{{route('admin.articles.index')}}" class="" method="GET">
                        <div class="form-group">
                            <label class="control-label {{request('category_id') ? 'text-primary'  : ''}}" for="status">Categorie</label>
                            <select name="category_id" class="form-control" onchange="this.form.submit()">

                                @if (request('root_id') != request('category_id'))
                                    <option value="">Toate din sectiune</option>
                                @endif

                                @foreach ($categories as $category)
                                    @if ($category->can_have_children)
                                        <optgroup label="{{$category->name}}">
                                            @foreach ($category->subcats as $subcategory)
                                                <option value="{{$subcategory->id}}"
                                                        {{ $subcategory->id == request('category_id') ? 'selected=selected' : '' }} >
                                                    {{$subcategory->name}}
                                                </option>
                                            @endforeach
                                        </optgroup>
                                    @else
                                        <option value="{{$category->id}}"
                                                {{ $category->id == request('category_id') ? 'selected=selected' : '' }} >
                                            {{$category->name}}
                                        </option>
                                    @endif

                                @endforeach
                            </select>
                            @foreach (request()->except(['page', 'category_id']) as $key => $value)
                                <input type="hidden" name="{{$key}}" value="{{$value}}">
                            @endforeach
                        </div>
                    </form>
                </div>
            @endif

        </div>


    </div>


    <div class="alert alert-light no-margins">
        <div class="row align-items-center">
            <div class="col-md my-1 my-md-0">
                {{$articles->total()}} articole
                @can('access')
                    @if (count(request()->except('page')))
                        <a href="{{route('admin.articles.index')}}" class="btn-white btn-sm m-l">
                            anuleaza toate filtrele
                        </a>
                    @endif
                @else
                    @if (count(request()->except('category_id', 'parent_id')))
                        <a href="{{route('admin.articles.index',  request()->only(['parent_id', 'category_id']))}}"
                           class="btn-white btn-sm m-l">
                            anuleaza toate filtrele
                        </a>
                    @endif
                @endcan
            </div>
        </div>
    </div>
    @if (request('q'))
        <p class="p-xs">
            Se cauta dupa
            <b>
                {{request('q')}}
            </b>
        </p>
    @endif

    <style>
        table td {
            vertical-align: middle !important;
        }
    </style>
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-content table-responsive">
                    <table class="table table-stripped toggle-arrow-tiny table-hover table-action " data-page-size="50"
                           data-filtering="true">
                        <thead>
                        <tr>
                            <th data-sort-ignore="true" style="width: 1%" class="text-nowrap">
                                #
                                <a href="{{route('admin.articles.index', ['order_by' =>  'id', 'order_direction' => 'asc'])}}"><i
                                            class="fa fa-caret-up"></i></a>
                                <a href="{{route('admin.articles.index', ['order_by' =>  'id', 'order_direction' => 'desc'])}}"><i
                                            class="fa fa-caret-down"></i></a>
                            </th>


                            <th data-toggle="true">Titlu</th>
                            <th data-toggle="true">Categorie</th>
                            {{--                            <th class="text-nowrap">Recomandat--}}
                            {{--                                <a href="{{route('admin.articles.index', ['order_by' =>  'is_featured', 'order_direction' => 'asc'])}}"><i--}}
                            {{--                                            class="fa fa-caret-up"></i></a>--}}
                            {{--                                <a href="{{route('admin.articles.index', ['order_by' =>  'is_featured', 'order_direction' => 'desc'])}}"><i--}}
                            {{--                                            class="fa fa-caret-down"></i></a>--}}
                            {{--                            </th>--}}

                            <th class="text-nowrap">Stare
                                <a href="{{route('admin.articles.index', ['order_by' =>  'status', 'order_direction' => 'asc'])}}"><i
                                            class="fa fa-caret-up"></i></a>
                                <a href="{{route('admin.articles.index', ['order_by' =>  'status', 'order_direction' => 'desc'])}}"><i
                                            class="fa fa-caret-down"></i></a>
                            </th>
                            <th class="text-right" data-sort-ignore="true">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($articles as $article)
                            <tr>
                                <td>
                                    <a href="{{route('admin.articles.edit', $article)}}">
                                        <img src="{{$article->getThumbUrl()}}"
                                             style="width: 64px; height:64px; object-fit: cover"/>
                                    </a>
                                </td>

                                <td>
                                    <a href="{{route('admin.articles.edit', $article)}}">{{ $article->title }}</a>
                                    <p>
                                        <small>
                                            Scris de {{$article->user ? $article->user->getName() : 'sters'}}
                                            la {{$article->created_at}}
                                        </small>
                                    </p>
                                </td>

                                <td>
                                    {{$article->category->path}}
                                </td>

                                {{--                                <td>--}}
                                {{--                                     <span class="badge badge-{{$article->is_featured ? 'success' : 'gray-bg'}}">--}}
                                {{--                                        {{$article->is_featured ? 'da' : 'nu'}}--}}
                                {{--                                    </span>--}}
                                {{--                                </td>--}}

                                <td>
                                    <span class="badge badge-{{$article->status_class}}">
                                        {{$article->status}}
                                    </span>
                                </td>

                                <td class="text-right">
                                    <div class="btn-group-or-not text-nowrap">
                                        @if ($article->isPending())
                                            <form action="{{route('admin.articles.update', $article)}}" class="inline"
                                                  method="POST">
                                                @csrf
                                                @method('PUT')
                                                <input type="hidden" name="status"
                                                       value="active"/>
                                                <input type="submit"
                                                       value="aproba"
                                                       class="btn btn-xs btn-warning"/>
                                            </form>
                                        @endif

                                        <a href="{{$article->getUrl()}}" class="btn-white btn btn-xs"
                                           target="_blank">vezi</a>
                                        <a href="{{route('admin.articles.edit', $article)}}"
                                           class="btn-success btn btn-xs btn-edit">edit</a>

                                        @if ($article->category->can_create_articles)
                                            <form action="{{route('admin.articles.destroy', $article)}}" class="inline"
                                                  method="POST">
                                                {{ method_field('DELETE' ) }}
                                                {{ csrf_field() }}
                                                <button type="submit" class="btn btn-xs btn-delete btn-danger"
                                                        onclick="return confirm('sigur stergeti?')">
                                                    sterge
                                                </button>

                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                        <tfoot>
                        <tr>
                            <td colspan="6">
                                <ul class="pagination pull-right"></ul>
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                    {{$articles->links('vendor.pagination.bootstrap')}}
                </div>
            </div>
        </div>
    </div>
@endsection
