@extends('layouts.admin')
@section('title', 'Reclame')


@section('actions')
    <a href="{{route('admin.ads.create')}}" class="btn btn-primary m-md">
        <i class="fa fa-plus-circle"></i>
        adauga
    </a>
@endsection

@section('content')
    <div class="ibox">
        <div class="ibox-content">
            <div class="row sortable" data-url="{{route('admin.ads.priority')}}">
                @foreach($ads as $ad)
                    <div class="col col-md-3 col-lg-3" data-id="{{$ad->id}}">
                        <div class="ibox">
                            <div class="ibox-content product-box">

                                <div class="product-imitation" style="background-image: url('{{$ad->getPhotoUrl()}}');">

                                </div>
                                <div class="product-desc">
                                    <div class="pull-right">
                                        <form action="{{route('admin.ads.destroy', $ad)}}" class="inline"
                                              method="POST">
                                            {{ method_field('DELETE' ) }}
                                            {{ csrf_field() }}

                                            <a href="{{route('admin.ads.edit', $ad)}}"
                                               class="btn btn-xs btn-outline btn-primary">Edit <i
                                                        class="fa fa-long-arrow-right"></i> </a>

                                            <button type="submit" class="btn btn-xs btn-delete btn-danger"
                                                    onclick="return confirm('sigur stergeti?')">
                                                sterge
                                            </button>
                                        </form>


                                    </div>
                                    <small class="text-muted">
                                        <span class="badge {{$ad->isActive() ? 'bg-success' : 'bg-danger'}}">
                                            {{$ad->isActive() ? 'activ' : 'inactiv'}}
                                        </span>
                                        <span class="small">
                                            Pozitie
                                            <span class="product-position ">
                                                {{$ad->priority}}
                                            </span>
                                            ,
                                            <b class="font-weight-bold">
                                                {{$ad->visibility}}
                                            </b>
                                        </span>
                                    </small>
                                    <span class="product-name">
{{--                                        <small class="pull-right text-muted">--}}
{{--                                            <b>{{$ad->hits}}</b> clicks--}}
{{--                                        </small>--}}


                                            <a href="{{route('admin.ads.edit', $ad)}}">
                                            {{$ad->title}}
                                            </a>


                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
            @include('admin.parts.sortable')
        </div>
    </div>
@endsection
