/**
 * Setup:
 *
 *     <link rel="stylesheet" href="{{asset('assets/site/plugins/cookieconsent/cookieconsent.css')}}">
 *     <script defer src="{{asset('assets/site/plugins/cookieconsent/cookieconsent.js')}}"></script>
 *     <script defer src="{{asset('assets/site/plugins/cookieconsent/init.js')}}"></script>
 *
 *
 *
 *     Add this if multi lingual site:
 *     <script defer type="module">
 *         cc.updateLanguage('{{config('app.locale')}}', true);
 *     </script>
 *
 */

var pagesUrls = {
    privacyPolicy: '/politica-de-confidentialitate.php',
    contact: '/contact.php',
}


// obtain plugin
var cc = initCookieConsent();

// run plugin with your configuration
cc.run({
    current_lang: 'ro',
    autoclear_cookies: true, // default: false
    page_scripts: true, // default: false

    // mode: 'opt-in'                          // default: 'opt-in'; value: 'opt-in' or 'opt-out'
    // delay: 0,                               // default: 0
    // auto_language: null                     // default: null; could also be 'browser' or 'document'
    // autorun: true,                          // default: true
    // force_consent: false,                   // default: false
    // hide_from_bots: true,                   // default: true
    // remove_cookie_tables: false             // default: false
    // cookie_name: 'cc_cookie',               // default: 'cc_cookie'
    // cookie_expiration: 182,                 // default: 182 (days)
    // cookie_necessary_only_expiration: 182   // default: disabled
    // cookie_domain: location.hostname,       // default: current domain
    // cookie_path: '/',                       // default: root
    // cookie_same_site: 'Lax',                // default: 'Lax'
    // use_rfc_cookie: false,                  // default: false
    // revision: 0,                            // default: 0

    onFirstAction: function (user_preferences, cookie) {
	// callback triggered only once
    },

    onAccept: function () {

    },

    onChange: function (cookie, changed_preferences) {
    },

    languages: {
	'ro': {
	    consent_modal: {
		title: 'Folosim cookies!',
		description: 'Acest site web utilizează cookie-uri esențiale pentru a asigura funcționarea corectă a acestuia și cookie-uri de urmărire pentru a înțelege modul în care interacționați cu acesta. Acestea din urmă vor fi setate numai după obținerea consimțământului. <button type="button" data-cc="c-settings" class="cc-link">Lăsați-mă să aleg</button>.',
		primary_btn: {
		    text: 'Acceptă toate',
		    role: 'accept_all'              // 'accept_selected' or 'accept_all'
		},
		secondary_btn: {
		    text: 'Respingeți toate',
		    role: 'accept_necessary'        // 'settings' or 'accept_necessary'
		}
	    },
	    settings_modal: {
		title: 'Preferințele privind cookie-urile',
		save_settings_btn: 'Salvează setările',
		accept_all_btn: 'Acceptă toate',
		reject_all_btn: 'Respingeți toate',
		close_btn_label: 'Închideți',
		cookie_table_headers: [
		    {col1: 'Nume'},
		    {col2: 'Domeniu'},
		    {col3: 'Descriere'},
			    // {col3: 'Expiration'},
			    // {col4: 'Description'}
		],
		blocks: [
		    {
			title: 'Utilizarea cookie-urilor 📢',
			description: 'Folosim cookie-uri pentru a asigura funcționalitățile de bază ale site-ului web și pentru a îmbunătăți experiența dvs. online. Puteți alege pentru fiecare categorie să optați pentru opt-in/out oricând doriți. Pentru mai multe detalii referitoare la cookie-uri și alte date sensibile, vă rugăm să citiți integral <a href="' + pagesUrls.privacyPolicy + '" class="cc-link">politica de confidențialitate</a>.'
		    }, {
			title: 'Cookie-uri strict necesare',
			description: 'Aceste module cookie sunt esențiale pentru buna funcționare a acestui site web. Fără aceste module cookie, site-ul web nu ar funcționa corespunzător.',
			toggle: {
			    value: 'necessary',
			    enabled: true,
			    readonly: true          // cookie categories with readonly=true are all treated as "necessary cookies"
			}
		    }, {
			title: 'Cookie-uri de performanță și de analiză',
			description: 'Aceste cookie-uri permit site-ului web să rețină alegerile pe care le-ați făcut în trecut.',
			toggle: {
			    value: 'analytics', // your cookie category
			    enabled: true,
			    readonly: false
			},
			cookie_table: [// list of all expected cookies
			    {
				col1: '^_ga', // match all cookies starting with "_ga"
				col2: 'google.com',
				col3: 'Google Analytics',
				// col4: 'description ...',
				is_regex: true
			    },
			    {
				col1: '_gid',
				col2: 'google.com',
				col3: 'Google Analytics',
				// col4: 'description ...',
			    },
			    {
				col1: '^_utm',
				col2: 'google.com',
				col3: 'Google Analytics',
				// col4: 'description ...',
			    }
			]
		    }, {
			title: 'Cookie-uri pentru publicitate și direcționare',
			description: 'Aceste module cookie colectează informații despre modul în care utilizați site-ul web, ce pagini ați vizitat și pe ce linkuri ați făcut clic. Toate aceste date sunt anonime și nu pot fi folosite pentru a vă identifica.',
			toggle: {
			    value: 'targeting',
			    enabled: true,
			    readonly: false
			}
		    }, {
			title: 'Mai multe informații',
			description: 'Pentru orice întrebări legate de politica noastră privind modulele cookie și opțiunile dumneavoastră, vă rugăm <a class="cc-link" href="' + pagesUrls.contact + '">contactați-ne</a>.',
		    }
		]
	    }
	},
	'en': {
	    consent_modal: {
		title: 'We use cookies!',
		description: 'This website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent. <button type="button" data-cc="c-settings" class="cc-link">Let me choose</button>',
		primary_btn: {
		    text: 'Accept all',
		    role: 'accept_all'              // 'accept_selected' or 'accept_all'
		},
		secondary_btn: {
		    text: 'Reject all',
		    role: 'accept_necessary'        // 'settings' or 'accept_necessary'
		}
	    },
	    settings_modal: {
		title: 'Cookie preferences',
		save_settings_btn: 'Save settings',
		accept_all_btn: 'Accept all',
		reject_all_btn: 'Reject all',
		close_btn_label: 'Close',
		cookie_table_headers: [
		    {col1: 'Name'},
		    {col2: 'Domain'},
		    {col3: 'Description'},
			    // {col3: 'Expiration'},
			    // {col4: 'Description'}
		],
		blocks: [
		    {
			title: 'Cookie usage 📢',
			description: 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="' + pagesUrls.privacyPolicy + '" class="cc-link">privacy policy</a>.'
		    }, {
			title: 'Strictly necessary cookies',
			description: 'These cookies are essential for the proper functioning of this website. Without these cookies, the website would not work properly',
			toggle: {
			    value: 'necessary',
			    enabled: true,
			    readonly: true          // cookie categories with readonly=true are all treated as "necessary cookies"
			}
		    }, {
			title: 'Performance and Analytics cookies',
			description: 'These cookies allow the website to remember the choices you have made in the past',
			toggle: {
			    value: 'analytics', // your cookie category
			    enabled: true,
			    readonly: false
			},
			cookie_table: [// list of all expected cookies
			    {
				col1: '^_ga', // match all cookies starting with "_ga"
				col2: 'google.com',
				col3: 'Google Analytics',
				// col4: 'description ...',
				is_regex: true
			    },
			    {
				col1: '_gid',
				col2: 'google.com',
				col3: 'Google Analytics',
				// col4: 'description ...',
			    },
			    {
				col1: '^_utm',
				col2: 'google.com',
				col3: 'Google Analytics',
				// col4: 'description ...',
			    }
			]
		    }, {
			title: 'Advertisement and Targeting cookies',
			description: 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you',
			toggle: {
			    value: 'targeting',
			    enabled: true,
			    readonly: false
			}
		    }, {
			title: 'More information',
			description: 'For any queries in relation to our policy on cookies and your choices, please <a class="cc-link" href="' + pagesUrls.contact + '">contact us</a>.',
		    }
		]
	    }
	},

    }
});