@extends('layouts.site')
@section('title', 'Stare plata')

@section('scripts')
    @if (request('good'))
        @include('site.parts.order_tracking')
    @endif
@endsection

@section('content')
    <div class="page-section section">
        <div class="container py-5 my-5 text-center" style="">
            <h2>
                <i class="fa fa-shopping-bag  text-{{$order->getPaymentStatusClass()}} fa-3x  anim-slide-down  animation-done animated"></i>
            </h2>
            <div class="h2 py-5">
                @if ($order->payment_status === 'paid')
                    Comanda a fost platita. Va multumim!
                @elseif ($order->payment_status === 'preauthorized')
                    Tranzactia a reusit. Va multumim!
                    {{--                    Tranzactia trebuie confirmata de catre furnizor.--}}
                    <p class="pt-3 h5 text-success">
                        Veti fi contactat telefonic pentru a confirma comanda.
                    </p>
                @else
                    Comanda nu a fost procesata cu success.
                @endif

                @if ($order->canPayWithCC())
                    <p class="my-4">
                        <a href="{{route('payment.redirect', ['order_code' => $order->code])}}"
                           class="btn btn-outline-success text-uppercase btn-lg">
                            incearca plata din nou
                        </a>
                    </p>
                @endif

                @if (!$order->hasValidPayment() && $transaction)
                    <p class="pt-3 h5 text-danger">
                        {{$transaction->status_text}}
                    </p>
                @endif
            </div>


            @if ($order->is_paid)
                <p>
                    In scurt timp veti primi un email cu detaliile comenzii.
                    <br/>
                    Valoare comandă: <b>{{$order->getTotalPrice()}} lei</b>.
                </p>
            @else
                <p>
                    In contul meu puteti vedea statusul comenzii dvs.
                </p>
            @endif


            @if (Payment::istTestMode())
                <div class="text-danger h2 my-5">
                    TEST MODE
                </div>
            @endif

            @auth
                <a href="{{route('client.orders.show', $order)}}" class="btn btn-outline-dark text-uppercase btn-lg">
                    detalii comanda
                </a>

            @endauth


        </div>
    </div>


@endsection

