@extends('layouts.admin')
@section('title', 'Comenzi')


@section('actions')
<div class="btn-group m-t-lg">
    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        Filtrare dupa metoda plata <span class="caret"></span>
    </button>
    <ul class="dropdown-menu">
        @foreach (['cc', 'ramburs'] as $payment_type)
        <li class="{{request('payment_type') == $payment_type ? 'active' : ''}}"><a href="{{route('admin.orders.index', compact('payment_type'))}}">{{$payment_type}}</a></li>
        @endforeach
        <li role="separator" class="divider"></li>
        <li><a href="{{route('admin.orders.index')}}">Toate</a></li>
    </ul>
</div>

<div class="btn-group m-t-lg">
    <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        Filtrare dupa stare CC<span class="caret"></span>
    </button>
    <ul class="dropdown-menu">
        @foreach (['0' => 'neplatite', '1' => 'platite'] as $is_paid => $value)
        <li class="{{request('is_paid') == $is_paid ? 'active' : ''}}"><a href="{{route('admin.orders.index', compact('is_paid') + ['payment_type' => 'cc'])}}">{{$value}}</a></li>
        @endforeach
        <li><a href="{{route('admin.orders.index',  ['is_paid' => 1, 'payment_type' => 'cc', 'status' => 'new'])}}">platite dar nelivrate</a></li>

        <li role="separator" class="divider"></li>
        <li><a href="{{route('admin.orders.index')}}">Toate</a></li>
    </ul>
</div>
@endsection

@section('content')

<div class="ibox">
    <div class="ibox-content">
        <table class="table table-striped-or-not table-hover">
            <thead>
                <tr>
                    <th>Nr</th>
                    <th>Data</th>
                    <th>Nume si prenume</th>
<!--                    <th>Firma</th>-->
                    <th>Telefon</th>
                    <th>Taxa transport</th>
                    <th>Total</th>
                    <th>Stare</th>
                    <th>AWB</th>
                    <th>Anuntat</th>
                    <th class="bg-muted">Mediu</th>            
                    <th class="bg-muted">Metoda plata</th>
                    <th class="bg-muted">Stare</th>
                    <th class="text-right">Actiuni</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($orders as $order)
                <tr role="button">
                    <td>
                        {{$order->id}}
                    </td>
                    <td>
                        {{$order->created_at}}
                    </td>
                    <td>
                        {{$order->deliveryContact ? $order->deliveryContact->getName() : 'deleted'}}
                    </td>
<!--                    <td>
                        {{@$order->deliveryContact->company_name}}
                    </td>-->
                    <td>
                        {{@$order->deliveryContact->phone}}
                    </td>
                    <td>
                        {{$order->price_delivery}} lei
                    </td>
                    <td>
                        {{$order->getTotalPrice()}} lei
                    </td>
                    <td>
                        <span class="badge badge-{{$order->status_class}}">
                            {{$order->status_detail}}
                        </span>
                    </td>
                    <td>

                        <i class="fa {{$order->awb ? 'fa-check-circle text-primary' : 'fa-times-circle text-muted'}}"></i>

                    </td>
                    <td>

                        <i class="fa  {{$order->delivery_mail_sent ? 'fa-check-circle text-primary' : 'fa-times-circle text-muted'}}"></i>

                    </td> 
                    <td class="bg-muted">
                        <span class="badge {{$order->payment_mode == 'test' ? 'badge-muted' : 'badge-primary' }}">
                            {{$order->payment_mode}}
                        </span>
                    </td>
                    <td class="bg-muted">
                        @if ($order->isCC())
                        <i class="fa far fa-credit-card text-success"></i>
                        @endif
                        {{$order->payment_type}}

                    </td>
                    <td class="bg-muted">
                        @if ($order->isCC())
                        <span class="badge badge-{{$order->getPaymentStatusClass()}}">
                            <i class="fa far {{$order->hasValidPayment() ? 'fa-check-circle': 'fa-times-circle'}} "></i> {{$order->getPaymentStatusMessage()}}
                        </span>

                        <small class="pull-right text-muted">
                            {{$order->payment_status}}
                        </small>


                        @else
                        - 

                        @endif
                    </td>
                    <td class="text-right">
                        <a href="{{route('admin.orders.show', $order)}}" class="btn btn-edit btn-xs btn-default">vezi</a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table> 
        {{$orders->links('vendor.pagination.bootstrap')}}
    </div>
</div>
@endsection
