<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class PaymentStructure extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {


        // transactions
        if (!Schema::hasTable('transactions')) {
            Schema::create('transactions', function (Blueprint $table) {
                $table->increments('id');
                $table->integer('order_id')->unsigned()->nullable()->index();

                $table->string('order_code')->nullable()->index();
                $table->string('external_order_id')->nullable();

                $table->enum('mode', ['live', 'test'])->default('test')->nullable();
                $table->integer('status_code')->nullable();
                $table->string('status_text')->nullable();
                $table->string('status')->nullable();
                $table->boolean('has_error')->default(0);

                $table->text('response')->nullable();

                $table->timestamps();
            });
        }

        // update order table
        Schema::table('orders', function (Blueprint $table) {
            if (!Schema::hasColumn('orders', 'payment_mode')) {
                $table->enum('payment_mode', ['live', 'test'])
                    ->default('test')
                    ->after('payment_type');
            }

            if (!Schema::hasColumn('orders', 'code')) {
                $table->string('code')
                    ->nullable()
                    ->after('id')
                    ->index();
            }

            if (!Schema::hasColumn('orders', 'payment_status')) {
                $table->enum('payment_status', ['paid', 'preauthorized', 'canceled', 'refunded', 'pending'])
                    ->nullable()
                    ->after('payment_mode')
                    ->index();
            }

            if (!Schema::hasColumn('orders', 'payment_status_code')) {
                $table->integer('payment_status_code')
                    ->nullable()
                    ->after('payment_status');
            }

            if (!Schema::hasColumn('orders', 'mail_sent')) {
                $table->boolean('mail_sent')->default(0)
                    ->after('payment_status');
            }
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

}
