<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class InitialStructure extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {


        // brands
        Schema::create('brands', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('slug');

            $table->text('description')->nullable();

            $table->string('url')->nullable();

            $table->string('logo')->nullable();


            $table->boolean('is_featured')->default(0);

            $table->timestamps();

            $table->index('slug');
            $table->index('is_featured');
        });


        // reviews
        Schema::create('reviews', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('article_id')->unsigned();
            $table->integer('user_id')->unsigned()->nullable();
            $table->integer('parent_id')->default(0)->unsigned();

            $table->boolean('is_active')->default(0);

            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->text('body');

            $table->string('filename')->nullable();

            $table->tinyInteger('rating')->default(0)->unsigned();
            $table->string('ip', '64')->nullable();
            $table->text('user_agent')->nullable();

            $table->timestamps();

            $table->index('article_id');
            $table->index(['article_id', 'is_active']);
            $table->index(['parent_id', 'is_active']);
        });


        // galleries (used for regions)
        Schema::create('galleries', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('slug');

            $table->integer('category_id')->nullable()->unsigned();

            $table->longText('description')->nullable();
            $table->string('url')->nullable();

            $table->boolean('is_active')->default(0);
            $table->boolean('is_featured')->default(0);


            $table->integer('photo_id')->unsigned()->nullable();
            $table->enum('status', ['active', 'inactive'])->default('inactive');

            $table->smallInteger('priority')->unsigned()->default(0);

            $table->timestamps();

            $table->index(['is_active', 'priority']);
            $table->index(['is_active']);
            $table->index(['category_id']);
            $table->index(['slug']);
            $table->index(['status']);
        });


        // gallery_photos
        Schema::create('gallery_photos', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('gallery_id')->unsigned();
            $table->string('filename');
            $table->smallInteger('priority')->unsigned()->default(0);

            $table->timestamps();

            $table->index('gallery_id');
            $table->index(['gallery_id', 'priority']);
        });


//        CATEGORII CU SUBCATEGORII PT ARTICLES.
        // blogs (articles)
        Schema::create('articles', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->unsigned();
            $table->string('slug');

            $table->integer('category_id')->unsigned()->index()->nullable();

            $table->string('title')->nullable();

            $table->longText('body')->nullable();
            $table->json('params')->nullable();
            $table->json('ingredients')->nullable();
            $table->json('steps')->nullable();
            $table->text('tips')->nullable();
            $table->json('categories')->nullable();

            $table->boolean('is_featured')->default(0);
            $table->boolean('has_slug_locked')->default(0);


            $table->enum('status', ['active', 'inactive'])->default('inactive');

            $table->integer('photo_id')->unsigned()->nullable();

            $table->text('search')->nullable();

            $table->smallInteger('comment_count')->unsigned()->default(0);


            $table->timestamp('published_at')->nullable();

            $table->timestamps();


            $table->index('created_at');
            $table->index('slug');

            $table->index(['status', 'published_at']);
            $table->index(['status', 'is_featured']);
            $table->index(['category_id', 'status', 'published_at']);

            $table->engine = 'InnoDB';
        });

        DB::statement('ALTER TABLE articles ADD FULLTEXT full(search)');


        // article_photos
        Schema::create('article_photos', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('article_id')->unsigned();
            $table->string('filename');
            $table->smallInteger('priority')->unsigned()->default(0);

            $table->timestamps();

            $table->index('article_id');
            $table->index(['article_id', 'priority']);
        });


        // categories
        Schema::create('categories', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name');
            $table->string('slug');
            $table->integer('parent_id')->default(0)->unsigned();

            $table->text('description')->nullable();


            //$table->integer('product_id')->nullable()->unsigned();
            $table->boolean('has_children')->default(0);
            $table->boolean('can_have_children')->default(0);
            $table->boolean('can_be_deleted')->default(1);
            $table->boolean('can_create_articles')->default(1);


            $table->string('photo')->nullable();
            $table->text('path');

            $table->boolean('show_in_menu')->default(0);
            $table->smallInteger('priority')->unsigned()->default(0);

            $table->timestamps();

            $table->boolean('is_active')->default(0);


            $table->index('parent_id');
            $table->index('slug');
            $table->index('show_in_menu');
            $table->index(['is_active', 'priority']);

            $table->index(['slug', 'parent_id']);
        });

        // documents
        Schema::create('article_documents', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('article_id')->unsigned();

            $table->string('slug');

            $table->string('filename');
            $table->text('name')->nullable();

            $table->smallInteger('priority')->unsigned()->default(0);


            $table->timestamps();

            $table->index('article_id');
            $table->index(['article_id', 'priority']);


            $table->engine = 'InnoDB';
        });

        // article_archives
        Schema::create('article_archives', function (Blueprint $table) {
            $table->increments('id');
            $table->smallInteger('year')->unsigned();
            $table->tinyInteger('month')->unsigned();

            $table->timestamps();

            $table->index(['year', 'month']);

            $table->engine = 'InnoDB';
        });


        // videos
        Schema::create('videos', function (Blueprint $table) {
            $table->increments('id');

            $table->string('youtube_id');
            $table->timestamps();
        });

        // mailing_lists
        Schema::create('mailing_lists', function (Blueprint $table) {
            $table->increments('id');
            $table->string('email');
            $table->integer('user_id')->unsigned()->nullable();

            $table->string('ip');
            $table->text('user_agent')->nullable();

            $table->timestamps();
            $table->index('email');
            $table->index('user_id');

        });


        // text blocks
        Schema::create('texts', function (Blueprint $table) {
            $table->increments('id');

            $table->string('slug')->nullable();

            $table->boolean('has_rich_editor')->default(0);

            $table->string('title')->nullable();

            $table->mediumText('body')->nullable();

            $table->smallInteger('priority')->unsigned()->default(0);

            $table->timestamps();

            $table->index('priority');
//            $table->index('photo_id');
            $table->index('slug');
        });


        // covers
        Schema::create('covers', function (Blueprint $table) {
            $table->increments('id');
            $table->string('slug');
            $table->string('filename');
            $table->string('product_filename')->nullable();
            $table->string('title')->nullable();
            $table->text('body')->nullable();
            $table->string('button_text')->nullable();
            $table->string('url')->nullable();
            $table->smallInteger('priority')->unsigned()->default(0);

            $table->boolean('is_active')->default(0);


            $table->timestamps();

            $table->index('slug');
            $table->index(['is_active', 'priority']);
            $table->index('is_active');

        });


        // ads
        Schema::create('ads', function (Blueprint $table) {
            $table->increments('id');

            $table->string('title');
            $table->string('photo')->nullable();
            $table->string('url')->nullable();

            $table->boolean('show_on_mobile')->default(1);
            $table->enum('visibility', ['global', 'category', 'cart'])->default('global');

            $table->smallInteger('priority')->unsigned()->default(0);
            $table->boolean('is_featured')->default(0);
            $table->boolean('is_active')->default(0);

            $table->integer('hits')->default(0);

            $table->timestamps();

            $table->index('visibility');
            $table->index(['visibility', 'priority']);
            $table->index('priority');
        });

        // cuisines
        Schema::create('cuisines', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('slug');


            $table->boolean('is_active')->default(0);

            $table->timestamps();

            $table->index(['is_active']);
            $table->index(['slug']);
        });

        // tags
        Schema::create('tags', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->nullable();
            $table->string('slug');


            $table->boolean('is_active')->default(0);

            $table->timestamps();

            $table->index(['is_active']);
            $table->index(['slug']);
        });

        // article_tag
        Schema::create('article_tag', function (Blueprint $table) {
            $table->integer('article_id')->unsigned()->index();
            $table->foreign('article_id')->references('id')->on('articles')->onDelete('cascade');

            $table->integer('tag_id')->unsigned()->index();
            $table->foreign('tag_id')->references('id')->on('tags')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

}
