<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');

            $table->string('slug')->nullable();

            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');

            $table->tinyInteger('is_admin')->default(0)->unsigned();
            $table->boolean('is_active')->default(1);



            $table->bigInteger('facebook_id')->nullable();
            $table->text('facebook_data')->nullable();

            $table->string('ip', '64')->nullable();
            $table->text('user_agent')->nullable();

            $table->string('search')->nullable();

            $table->rememberToken();
            $table->timestamps();

            $table->index('slug');


        });

        DB::statement('ALTER TABLE users ADD FULLTEXT full(search)');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }

}
