<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use File;
use Image;
use StringOperation;

class WordpressPost extends Model
{

    /**
     * Protected values by mass assignament
     *
     * @var array
     */
    protected $guarded = ['id'];
    protected $table = 'wp_posts';

    public function scopeActive($query)
    {
        // SELECT * FROM `wp_posts` WHERE `post_status` = 'publish' and post_type='post'

        $query->where('post_status', 'publish')
            ->where('post_type', 'inspiry_recipes')
            ->orderBy('ID');
    }

    public function categories()
    {
        return $this->hasMany('App\Model\WordpressCategory', 'object_id', 'ID');
    }

    public function photo()
    {
        return $this->hasOne('App\Model\WordpressPostMeta', 'post_id', 'ID')->where('meta_key', '_thumbnail_id');
    }

    public function meta()
    {
        return $this->hasMany('App\Model\WordpressPostMeta', 'post_id', 'ID');
    }

    public function comments()
    {
        return $this->hasMany('App\Model\WordpressComment', 'comment_post_ID', 'ID')->where('comment_approved', 1);
    }

    public function getSrcAttribute()
    {
        return preg_replace('#.*/wp-content(?=/)#i', '', $this->guid);
    }

    public function getPostContentAttribute($value)
    {
        // remove gallery meta data
        $value = preg_replace('#\[gallery [^\]]+\]#', '', $value);

        // replace wp images to actual ones.
        return preg_replace('#http://sportmacsimsiemotie.ro/wp-content/uploads/#', '/uploads/', $value);
    }

    public function photos()
    {
        return $this->hasMany(self::class, 'post_parent', 'ID')->where('post_type', 'attachment');
    }

}
