<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Video extends Model
{

    protected $guarded = ['id'];

    protected static function boot()
    {
        parent::boot();

        static::addGlobalScope('order', function ($builder) {
            $builder->orderByDesc('id');
        });
    }


    public function getUrl() {
        return 'https://www.youtube.com/watch?v=' . $this->youtube_id;
    }

     public function getPhotoUrl() {
        return "//img.youtube.com/vi/{$this->youtube_id}/sddefault.jpg";
    }


}
