<?php

namespace App\Model;

trait TranslatableColumn
{

    public function getTranslatedValue($key)
    {
        if (!empty($this->attributes[$key])) {
            return $this->attributes[$key];
        }

        $locale = app()->getLocale();
        $col = $key . '_' . $locale;
        $failback_col = implode('_', [$key, config('app.fallback_locale')]);
        return $this->{$col} ? $this->{$col} : $this->{$failback_col};
    }

    public function getDescriptionAttribute()
    {
        return $this->getTranslatedValue('description');
    }

    public function getBodyAttribute()
    {
        return $this->getTranslatedValue('body');
    }

    public function getTitleAttribute()
    {
        return $this->getTranslatedValue('title');
    }

    public function getNameAttribute()
    {
        return $this->getTranslatedValue('name');
    }

    public function getValueAttribute()
    {
        return $this->getTranslatedValue('value');
    }

    public function getPathAttribute()
    {
        return $this->getTranslatedValue('path');
    }

    public function getUrlAttribute()
    {
        return $this->getTranslatedValue('url');
    }

}
