<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;


class Text extends Model
{

//    use TranslatableColumn;

    protected $guarded = ['id'];

    protected static function boot()
    {
        parent::boot();

//        static::deleting(function ($model) {
//            foreach ($model->photos as $photo) {
//                $photo->delete();
//            }
//        });
    }


    public function city()
    {
        return $this->belongsTo('App\Model\City');
    }

    public function photo()
    {
        return $this->belongsTo('App\Model\Text\TextPhoto');
    }

    public function photos()
    {
        return $this->hasMany('App\Model\Text\TextPhoto')->orderBy('priority')->orderBy('id');
    }

    public function getDummyImage()
    {
        return 'data:image/gif;base64,R0lGODlhAQABAIAAAMLCwgAAACH5BAAAAAAALAAAAAABAAEAAAICRAEAOw==';
    }

    public function getUrl()
    {
        return '#';
    }

    public function getPhotoUrl()
    {
        if ($this->photo) {
            return $this->photo->getPhotoUrl();
        }
        return $this->getDummyImage();
    }

    public function getThumbUrl()
    {
        if ($this->photo) {
            return $this->photo->getThumbUrl();
        }
        return $this->getDummyImage();
    }


}
