<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Utils;
use Str;

class Tag extends Model
{
    protected $guarded = ['id'];

    public static function boot()
    {
        parent::boot();

        static::saving(function ($model) {
            $model->slug = Str::slug($model->name);
        });

    }

    public function articles()
    {
        return $this->belongsToMany('App\Model\Article');
    }

    public function scopeFeatured($query)
    {
        $query->where('is_featured', true);
    }

    public function getUrl()
    {
        return route('site.articles.tag', $this);
    }

}
