<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

/**
 * App\Model\MailingList
 *
 * @property int $id
 * @property string $email
 * @property string $ip
 * @property string $user_agent
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList whereEmail($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList whereIp($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\MailingList whereUserAgent($value)
 * @mixin \Eloquent
 */
class MailingList extends Model
{

    protected $guarded = ['id'];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->ip = request()->ip();
            $model->user_id = auth()->check() ? auth()->id() : null;
            $model->user_agent = request()->userAgent();
        });

    }

}
