<?php

namespace App\Model\Article;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;

/**
 * App\Model\Article\ArticleComment
 *
 * @property-read \App\Model\Article $article
 * @property-read \App\Model\User $user
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleComment active()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleComment newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleComment newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleComment query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleComment recent()
 * @mixin \Eloquent
 */
class ArticleComment extends Model
{


    protected $fillable = ['name', 'body', 'email', 'is_active'];

    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->user_id = Auth::id();
        });
    }

    public function article()
    {
        return $this->belongsTo('App\Model\Article');
    }

    public function user()
    {
        return $this->belongsTo('App\Model\User');
    }

    public function scopeActive($query)
    {
        $query->where('is_active', true);
    }

    public function scopeRecent($query)
    {
        $query->orderByDesc('id');
    }


}
