<?php

namespace App\Model\Article;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

/**
 * App\Model\Article\ArticleArchive
 *
 * @property int $id
 * @property int $year
 * @property int $month
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read mixed $month_name
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive query()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive whereMonth($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Model\Article\ArticleArchive whereYear($value)
 * @mixin \Eloquent
 */
class ArticleArchive extends Model {

//    protected $dates = [
//        'from', 
//        'to',
//    ];

    public function addArchive($date) {
        // @todo see why not all casted instances are date!
        if (!$date instanceof Carbon) {
            $date = new Carbon($date);
        }

        // skip if we   already have an archive entry
        if ($this->where('year', $date->year)->where('month', $date->month)->count()) {
            return;
        }

        // save archive
        $this->year = $date->year;
        $this->month = $date->month;
        $this->save();
    }

    public function getMonthNameAttribute($value) {
        $months = [
            1 => __('January'),
            2 => __('February'),
            3 => __('March'),
            4 => __('April'),
            5 => __('May'),
            6 => __('June'),
            7 => __('July'),
            8 => __('August'),
            9 => __('September'),
            10 => __('October'),
            11 => __('November'),
            12 => __('December'),
        ];

        return $months[$this->month];
    }

}
