<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;
use Cache;
use Illuminate\Support\Str;
use Utils;
use File;


class Ad extends Model
{

    use EnumValues;
//    use Hits;

    protected $guarded = ['id'];

    protected $casts = [
        // 'options' => 'array', // JSON serialize
    ];


    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            $model->priority = 9999;
        });

        // we want the categories to be sorted always by priority.
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('priority', 'asc');
        });

        static::deleting(function ($model) {
            File::delete( public_path('storage/' . config('paths.featuring')) .'/' . $model->photo);
        });
    }

    public function scopeActive($query)
    {
        $query->where('is_active', true);
    }

    public function scopeSection($query, string $visiblity) {
        $query->whereIn('visibility', ['global', $visiblity]);
    }

    public function getSlugAttribute($value)
    {
        return $value ?: Str::slug($this->title);
    }

    public function getPhotoUrl()
    {
        return Utils::storageUrl('featuring', $this->photo);
    }

    public function getUrl() {
        return route('site.ads.redirect', $this);
    }

    public function isActive()
    {
        return $this->is_active;
    }

}
