<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;


class Form extends Mailable {

    use Queueable,
        SerializesModels;

    public $data;
    public $files = [];

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data, $files = []) {
        $this->data = (object)$data;
        $this->files = $files;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build() {
        foreach ($this->files as $file) {
            $this->attach($file); // getPath()
        }
        return $this
                ->subject('Formular ' . @$this->data->type)
                ->replyTo($this->data->email ?? config('mail.from.address'), $this->data->firstname ?? config('mail.from.address'))
                ->markdown('emails.form');
    }

}
