<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreReview extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'body' => 'required|min:2',
            'email' => auth()->check() ? '' : 'required|email',
            'name' => auth()->check() ? '' : 'required',
            'photo' => 'mimes:jpeg,bmp,png,svg,webp'
//            'rating' => 'numeric|between:1,5'
        ];
    }

}
