<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePhoto extends FormRequest {

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize() {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules() {
        // only if we get a file we need da' rule.
        if ($this->hasFile('photo')) {
            return [
                'photo' => 'mimes:jpeg,bmp,png,svg,webp'
            ];
        }

        return [];
    }

}
