<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;

class StoreDocument extends FormRequest {

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize() {
        return true;
    }

    /**
     *  Overrides the default translations for particular fields.
     * 
     * @return array
     */

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules() {
        return [
            'name' => 'required|min:3',
            // we need file only when creating a new document.
            'file' => $this->method() === 'PUT' ? '' : 'required|mimes:' . implode(',', config('uploads.allowed_extensions')) . '|max:' . config('uploads.max_size'),
//            'file' => $this->method() === 'PUT' ? '' : 'required|max:' . config('uploads.max_size'),
        ];
    }

}
