<?php

namespace App\Http\Controllers\Site;

use App\Model\Article;
use App\Model\Category;
use App\Model\Cover;
use App\Model\Order;
use App\Model\Product;
use App\Model\User;
use App\Model\Video;
use Route;
use Debugbar;


class IndexController extends BaseController
{

    public function index()
    {

        view()->share('current_section', 'home');

        $categories = Category::recipe()->priority()->active()->get();

        $articles = Article::with('photo')
            ->blog()->active()
//            ->featured()
            ->recent()
            ->limit(3)->get();


        $recipes = Article::select('title', 'slug', 'id', 'photo_id', 'category_id', 'params')
		->with(['photo', 'category'])
            ->recipe()->active()->recent()
            ->limit(config('pagination.items_per_page'))
            ->get();


        return view('site.index', compact('recipes', 'categories', 'articles'));
    }

    public function videos()
    {
        $videos = Video::all();
        return view('site.video.index', compact('videos'));
    }

}
