<?php

namespace App\Http\Controllers\Site;

use App\Model\Brand;
use App\Model\Gallery;
use App\Model\Video;
use Illuminate\Http\Request;
use App\Http\Requests\StoreReview;

class GalleryController extends BaseController
{
    public function index(Request $request)
    {
        view()->share('current_section', 'gallery');

        $this->loadTexts([
            'regions',
        ]);

        $galleries = Gallery::with('photos')
            ->active()->get();

        // show only brands that have Wine products.
//        $brands = Brand::wines()->get();

        return view('site.gallery.index', compact('galleries'));
    }

    public function show($slug, Gallery $gallery)
    {
        if ($gallery->status == 'hidden') {
            abort(404);
        }

        // redirect if slug changed
        if ($slug != $gallery->slug) {
            return redirect($gallery->getUrl());
        }

        $category = $gallery->category;


        return view('site.gallery.show', compact('gallery', 'category') + [
                //'recent_gallerys' => RecentGallerys::instance()->allWithDB($gallery),
//                'gallerys' => $gallery->getSimilar(8),
            ]);
    }


}
