<?php

namespace App\Http\Controllers\Site;

use App\Mail\Form;
use App\Mail\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Arr;
use Mail;
use App\Mail\Contact;


class ContactController extends BaseController
{

    public function contact(Request $request)
    {
        view()->share('current_section', 'contact');

        // if we got a post threat it as it is.
        if ($request->isMethod('post')) {
            // validate request
            $this->validate($request, [
                'body' => 'required|min:1',
                'email' => 'required|email',
                'g-recaptcha-response' => 'required|recaptcha',
            ]);
            // go and send!
            // config('mail.from.address')
            Mail::to((object)['email' => env('MAIL_OFFICE')])->send(new Contact($request->all()));

            return back()->with('status', __('Your message was sent. Thank you!'));
        }
        return view('site.pages.contact');
    }

    public function product(Request $request)
    {
        // if we got a post threat it as it is.
        if ($request->isMethod('post')) {
            // validate request
            $this->validate($request, [
//                'email' => 'required|email',
                'telefon' => 'required',
//                'g-recaptcha-response' => 'required|recaptcha',
                'photo' => 'mimes:jpeg,bmp,png,svg,gif|max:40000',
                'aprot' => 'required'
            ], [
                'aprot.required' => 'Oh what',
            ]);

            // go and send!

            Mail::to((object)['email' => env('MAIL_OFFICE')])
                ->send(new Product($request->except(['photo', 'aprot', '_token']),
                    $request->hasFile('photo') ? Arr::wrap($request->file('photo')) : []));

            return back()->with('status', 'Solicitarea a fost trimisă. Mulțumim!');
        }


        $this->loadTexts([
            'product_request',
        ]);

        return view('site.contact.product');
    }

}
